/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.accumulo;

import com.google.common.base.Preconditions;

public class Column {
    private final Type columnType;
    private String columnFamily;
    private String columnQualifier;

    public Column(String col) {
        Preconditions.checkNotNull(col);
        int index = col.indexOf(58);
        if (-1 == index) {
            this.columnFamily = col;
            this.columnQualifier = null;
            if (this.columnFamily.endsWith("*")) {
                this.columnFamily = this.columnFamily.substring(0, this.columnFamily.length() - 1);
                this.columnType = Type.COLFAM_PREFIX;
            } else {
                this.columnType = Type.LITERAL;
            }
        } else {
            if (1 == col.length()) {
                throw new IllegalArgumentException("Cannot parse '" + col + "'");
            }
            this.columnFamily = col.substring(0, index);
            this.columnQualifier = col.substring(index + 1);
            if (this.columnFamily.endsWith("*")) {
                this.columnType = Type.COLFAM_PREFIX;
                this.columnFamily = this.columnFamily.substring(0, this.columnFamily.length() - 1);
            } else if (this.columnQualifier.isEmpty()) {
                this.columnType = Type.COLQUAL_PREFIX;
            } else if (this.columnQualifier.endsWith("*")) {
                this.columnType = Type.COLQUAL_PREFIX;
                this.columnQualifier = this.columnQualifier.substring(0, this.columnQualifier.length() - 1);
            } else {
                this.columnType = Type.LITERAL;
            }
        }
    }

    public Type getType() {
        return this.columnType;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public String getColumnQualifier() {
        return this.columnQualifier;
    }

    public boolean matchAll() {
        return Type.COLFAM_PREFIX.equals((Object)this.columnType) && "".equals(this.columnFamily);
    }

    public boolean equals(Object o) {
        if (o instanceof Column) {
            Column other = (Column)o;
            if (null != this.columnFamily) {
                if (null == other.columnFamily) {
                    return false;
                }
                if (!this.columnFamily.equals(other.columnFamily)) {
                    return false;
                }
            }
            if (null != this.columnQualifier) {
                if (null == other.columnQualifier) {
                    return false;
                }
                if (!this.columnQualifier.equals(other.columnQualifier)) {
                    return false;
                }
            }
            return this.columnType == other.columnType;
        }
        return false;
    }

    public String toString() {
        return (Object)((Object)this.columnType) + " " + this.columnFamily + ":" + this.columnQualifier;
    }

    public static enum Type {
        LITERAL,
        COLFAM_PREFIX,
        COLQUAL_PREFIX;

    }
}

