/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;

@InterfaceAudience.Private
public class MetricsMasterSourceImpl
extends BaseSourceImpl
implements MetricsMasterSource {
    private final MetricsMasterWrapper masterWrapper;
    private MetricMutableCounterLong clusterRequestsCounter;

    public MetricsMasterSourceImpl(MetricsMasterWrapper masterWrapper) {
        this("Server", "Metrics about HBase master server", "master", "Master,sub=Server", masterWrapper);
    }

    public MetricsMasterSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper masterWrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.masterWrapper = masterWrapper;
    }

    @Override
    public void init() {
        super.init();
        this.clusterRequestsCounter = this.metricsRegistry.newCounter("clusterRequests", "", 0L);
    }

    public void incRequests(int inc) {
        this.clusterRequestsCounter.incr((long)inc);
    }

    @Override
    public void getMetrics(MetricsBuilder metricsBuilder, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsBuilder.addRecord(this.metricsName);
        if (this.masterWrapper != null) {
            metricsRecordBuilder.addGauge("masterActiveTime", "Master Active Time", this.masterWrapper.getActiveTime()).addGauge("masterStartTime", "Master Start Time", this.masterWrapper.getStartTime()).addGauge("averageLoad", "AverageLoad", this.masterWrapper.getAverageLoad()).tag("liveRegionServers", "Names of live RegionServers", this.masterWrapper.getRegionServers()).addGauge("numRegionServers", "Number of RegionServers", this.masterWrapper.getNumRegionServers()).tag("deadRegionServers", "Names of dead RegionServers", this.masterWrapper.getDeadRegionServers()).addGauge("numDeadRegionServers", "Number of dead RegionServers", this.masterWrapper.getNumDeadRegionServers()).tag("zookeeperQuorum", "Zookeeper Quorum", this.masterWrapper.getZookeeperQuorum()).tag("serverName", "Server Name", this.masterWrapper.getServerName()).tag("clusterId", "Cluster Id", this.masterWrapper.getClusterId()).tag("isActiveMaster", "Is Active Master", String.valueOf(this.masterWrapper.getIsActiveMaster()));
        }
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
    }
}

