/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.annotations.StdCall;
import com.kenai.jaffl.annotations.Synchronized;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.Library;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeInvocationHandler
implements InvocationHandler {
    private final InvokerMap invokers;
    private final Library library;
    private final Map<LibraryOption, Object> optionsMap;
    private final Class<?> interfaceClass;

    public NativeInvocationHandler(Library library2, Class<?> interfaceClass, Map<LibraryOption, ?> optionsMap) {
        this.library = library2;
        this.interfaceClass = interfaceClass;
        this.optionsMap = new HashMap(optionsMap);
        if (interfaceClass.getAnnotation(StdCall.class) != null) {
            this.optionsMap.put(LibraryOption.CallingConvention, (Object)CallingConvention.STDCALL);
        }
        this.invokers = new InvokerMap(interfaceClass.getDeclaredMethods().length);
    }

    public static <T> T wrapInterface(Library library2, Class<T> interfaceClass, Map<LibraryOption, ?> optionsMap) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new NativeInvocationHandler(library2, interfaceClass, optionsMap)));
    }

    private Invoker getInvoker(Method method2) {
        Invoker invoker = this.invokers.get(method2);
        if (invoker != null) {
            return invoker;
        }
        return this.createInvoker(method2);
    }

    private synchronized Invoker createInvoker(Method method2) {
        Invoker invoker = this.invokers.get(method2);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.library.getInvoker(method2, this.optionsMap);
        if (method2.getAnnotation(Synchronized.class) != null || this.interfaceClass.getAnnotation(Synchronized.class) != null) {
            invoker = new SynchronizedInvoker(invoker, this.library.libraryLock());
        }
        this.invokers.put(method2, invoker);
        return invoker;
    }

    @Override
    public Object invoke(Object self, Method method2, Object[] argArray) throws Throwable {
        return this.getInvoker(method2).invoke(argArray);
    }

    private static final class InvokerMap {
        private volatile Object[] entries;
        private static final float loadFactor = 0.5f;
        private static final Hasher hasher = Platform.getPlatform().getJavaMajorVersion() >= 6 ? IdentityHasherSingleton.getInstance() : NameHasherSingleton.getInstance();

        public InvokerMap(int maxEntries) {
            int size2;
            int capacity = (int)((float)maxEntries / 0.5f) + 1;
            for (size2 = 1; size2 < capacity; size2 <<= 1) {
            }
            this.entries = new Object[size2 * 2];
        }

        public final synchronized void put(Method method2, Invoker invoker) {
            Object[] tmp = new Object[this.entries.length];
            System.arraycopy(this.entries, 0, tmp, 0, tmp.length);
            int start2 = InvokerMap.indexFor(method2, tmp.length);
            block0: for (int loop2 = 0; loop2 < 2; ++loop2) {
                for (int i2 = start2; i2 < tmp.length - 1; i2 += 2) {
                    if (tmp[i2] != null) continue;
                    tmp[i2] = method2;
                    tmp[i2 + 1] = invoker;
                    break block0;
                }
                start2 = 0;
            }
            this.entries = tmp;
        }

        public final Invoker get(Method method2) {
            Object[] tmp = this.entries;
            int start2 = InvokerMap.indexFor(method2, tmp.length);
            block0: for (int loop2 = 0; loop2 < 2; ++loop2) {
                for (int i2 = start2; i2 < tmp.length - 1; i2 += 2) {
                    if (tmp[i2] == method2) {
                        return (Invoker)tmp[i2 + 1];
                    }
                    if (tmp[i2] == null) break block0;
                }
                start2 = 0;
            }
            return null;
        }

        private static final int indexFor(Method key2, int length2) {
            return hasher.hash(key2) & length2 - 1;
        }

        private static final class NameHasherSingleton {
            private NameHasherSingleton() {
            }

            public static final Hasher getInstance() {
                return new NameHasher();
            }

            private static final class NameHasher
            implements Hasher {
                private NameHasher() {
                }

                public final int hash(Method key2) {
                    int h = key2.hashCode();
                    h += h << 15 ^ 0xFFFFCD7D;
                    h ^= h >>> 10;
                    h += h << 3;
                    h ^= h >>> 6;
                    h += (h << 2) + (h << 14);
                    return h ^ h >>> 16;
                }
            }
        }

        private static final class IdentityHasherSingleton {
            private IdentityHasherSingleton() {
            }

            public static final Hasher getInstance() {
                return new IdentityHasher();
            }

            private static final class IdentityHasher
            implements Hasher {
                private IdentityHasher() {
                }

                public final int hash(Method key2) {
                    int h = System.identityHashCode(key2);
                    return (h << 1) - (h << 8);
                }
            }
        }

        private static interface Hasher {
            public int hash(Method var1);
        }
    }

    private static final class SynchronizedInvoker
    implements Invoker {
        private final Object lock;
        private final Invoker invoker;

        public SynchronizedInvoker(Invoker invoker, Object lock2) {
            this.invoker = invoker;
            this.lock = lock2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object[] parameters2) {
            Object object = this.lock;
            synchronized (object) {
                return this.invoker.invoke(parameters2);
            }
        }
    }
}

