/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class PsychToRuby {
    public static void initPsychToRuby(Ruby runtime2, RubyModule psych2) {
        RubyModule visitors = runtime2.defineModuleUnder("Visitors", psych2);
        RubyClass visitor = runtime2.defineClassUnder("Visitor", runtime2.getObject(), runtime2.getObject().getAllocator(), visitors);
        RubyClass psychToRuby = runtime2.defineClassUnder("ToRuby", visitor, RubyObject.OBJECT_ALLOCATOR, visitors);
        psychToRuby.defineAnnotatedMethods(PsychToRuby.class);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject build_exception(ThreadContext context, IRubyObject self, IRubyObject klass, IRubyObject message2) {
        if (klass instanceof RubyClass) {
            IRubyObject exception2 = ((RubyClass)klass).allocate();
            exception2.getInternalVariables().setInternalVariable("mesg", message2);
            return exception2;
        }
        throw context.runtime.newTypeError(klass, context.runtime.getClassClass());
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject path2class(ThreadContext context, IRubyObject self, IRubyObject path2) {
        try {
            return context.runtime.getClassFromPath(path2.asJavaString());
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == context.runtime.getNameError()) {
                throw context.runtime.newArgumentError("undefined class/module " + path2);
            }
            throw re;
        }
    }
}

