/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafePropertyAccessor {
    public static boolean getBoolean(String property) {
        try {
            return Boolean.getBoolean(property);
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean getBoolean(String property, boolean defValue) {
        try {
            if (System.getProperty(property) != null) {
                return Boolean.getBoolean(property);
            }
            return defValue;
        }
        catch (SecurityException se) {
            return defValue;
        }
    }

    public static String getProperty(String property) {
        return SafePropertyAccessor.getProperty(property, null);
    }

    public static String getProperty(String property, String defValue) {
        try {
            return System.getProperty(property, defValue);
        }
        catch (SecurityException se) {
            return defValue;
        }
    }

    public static int getInt(String property) {
        return SafePropertyAccessor.getInt(property, 0);
    }

    public static int getInt(String property, int defValue) {
        try {
            return Integer.parseInt(System.getProperty(property, String.valueOf(defValue)));
        }
        catch (SecurityException se) {
            return defValue;
        }
    }

    public static boolean isSecurityProtected(String property) {
        try {
            System.getProperty(property);
            return false;
        }
        catch (SecurityException se) {
            return true;
        }
    }

    public static String getenv(String name2) {
        try {
            return System.getenv(name2);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    public static Map<String, String> getenv() {
        try {
            return System.getenv();
        }
        catch (SecurityException se) {
            return null;
        }
    }
}

