/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Accumulator;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.AlgebraicMathBase;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public abstract class AlgebraicByteArrayMathBase
extends AlgebraicMathBase<Double>
implements Accumulator<Double> {
    private Double intermediateVal = null;

    protected static Double getSeed(AlgebraicMathBase.KNOWN_OP op) {
        switch (op) {
            case SUM: {
                return 0.0;
            }
            case MIN: {
                return Double.POSITIVE_INFINITY;
            }
            case MAX: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return null;
    }

    private static Double doWork(Double arg1, Double arg2, AlgebraicMathBase.KNOWN_OP op) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        switch (op) {
            case MAX: {
                return Math.max(arg1, arg2);
            }
            case MIN: {
                return Math.min(arg1, arg2);
            }
            case SUM: {
                return arg1 + arg2;
            }
        }
        return null;
    }

    protected static Double doTupleWork(Tuple input, AlgebraicMathBase.KnownOpProvider opProvider, byte expectedType) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values == null || values.size() == 0L) {
            return null;
        }
        double sofar = AlgebraicByteArrayMathBase.getSeed(opProvider.getOp());
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Double d;
                switch (expectedType) {
                    case 50: {
                        DataByteArray dba = (DataByteArray)t.get(0);
                        d = dba != null ? Double.valueOf(dba.toString()) : null;
                        break;
                    }
                    case 25: {
                        d = (Double)t.get(0);
                        break;
                    }
                    default: {
                        throw new ExecException("Unexpected type in AlgebraicByteArrayMath " + DataType.findTypeName(expectedType));
                    }
                }
                if (d == null) continue;
                sawNonNull = true;
                sofar = AlgebraicByteArrayMathBase.doWork(sofar, d, opProvider.getOp());
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                throw new ExecException("Problem doing work on Doubles", errCode, 4, exp);
            }
        }
        return sawNonNull ? Double.valueOf(sofar) : null;
    }

    @Override
    public Double exec(Tuple input) throws IOException {
        try {
            return AlgebraicByteArrayMathBase.doTupleWork(input, this.opProvider, (byte)50);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on Doubles", errCode, 4, e);
        }
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 25));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Double curVal = AlgebraicByteArrayMathBase.doTupleWork(b, this.opProvider, (byte)50);
            if (curVal == null) {
                return;
            }
            if (this.intermediateVal == null) {
                this.intermediateVal = AlgebraicByteArrayMathBase.getSeed(this.opProvider.getOp());
            }
            this.intermediateVal = AlgebraicByteArrayMathBase.doWork(this.intermediateVal, curVal, this.opProvider.getOp());
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on Doubles", errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateVal = null;
    }

    @Override
    public Double getValue() {
        return this.intermediateVal;
    }

    public static abstract class Final
    extends AlgebraicMathBase.Final<Double> {
        @Override
        public Double exec(Tuple input) throws IOException {
            try {
                return AlgebraicByteArrayMathBase.doTupleWork(input, this, (byte)25);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on Doubles", errCode, 4, e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                if (bg.iterator().hasNext()) {
                    DataByteArray dba = (DataByteArray)bg.iterator().next().get(0);
                    Double d = dba != null ? Double.valueOf(dba.toString()) : null;
                    return tfact.newTuple(d);
                }
                return tfact.newTuple((Object)null);
            }
            catch (ExecException e) {
                throw e;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing an algebraic function", errCode, 4, e);
            }
        }
    }

    public static abstract class Intermediate
    extends AlgebraicMathBase.Intermediate {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(AlgebraicByteArrayMathBase.doTupleWork(input, this, (byte)25));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on Doubles", errCode, 4, e);
            }
        }
    }
}

