/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.util.PropertiesUtil;

public class ConfigurationValidator {
    private static final Log log = LogFactory.getLog(PropertiesUtil.class);

    public static void validatePigProperties(Properties properties) {
        ConfigurationValidator.ensureLongType(properties, "pig.spill.size.threshold", 5000000L);
        ConfigurationValidator.ensureLongType(properties, "pig.spill.gc.activation.size", 40000000L);
    }

    public static Properties getValidatedProperties(Properties properties) {
        Properties result = new Properties();
        String[] propertiesToValidate = new String[]{"pig.spill.size.threshold", "pig.spill.gc.activation.size"};
        ConfigurationValidator.validatePigProperties(properties);
        for (String p : propertiesToValidate) {
            result.setProperty(p, properties.getProperty(p));
        }
        return result;
    }

    private static void ensureLongType(Properties properties, String key, long defaultValue) {
        String str = properties.getProperty(key);
        if (str != null) {
            try {
                Long.parseLong(str);
            }
            catch (NumberFormatException nfe) {
                log.error((Object)(str + " has to be parsable to long"));
                properties.setProperty(key, Long.toString(defaultValue));
            }
        } else {
            properties.setProperty(key, Long.toString(defaultValue));
        }
    }
}

