/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
class SplitRequest
implements Runnable {
    static final Log LOG = LogFactory.getLog(SplitRequest.class);
    private final HRegion parent;
    private final byte[] midKey;
    private final HRegionServer server;
    private TableLockManager.TableLock tableLock;

    SplitRequest(HRegion region, byte[] midKey, HRegionServer hrs) {
        Preconditions.checkNotNull((Object)hrs);
        this.parent = region;
        this.midKey = midKey;
        this.server = hrs;
    }

    public String toString() {
        return "regionName=" + this.parent + ", midKey=" + Bytes.toStringBinary((byte[])this.midKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block38: {
            if (this.server.isStopping() || this.server.isStopped()) {
                LOG.debug((Object)("Skipping split because server is stopping=" + this.server.isStopping() + " or stopped=" + this.server.isStopped()));
                return;
            }
            boolean success = false;
            this.server.getMetrics().incrSplitRequest();
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            SplitTransaction st = new SplitTransaction(this.parent, this.midKey);
            try {
                this.tableLock = this.server.getTableLockManager().readLock(this.parent.getTableDesc().getTableName(), "SPLIT_REGION:" + this.parent.getRegionNameAsString());
                try {
                    this.tableLock.acquire();
                }
                catch (IOException ex) {
                    this.tableLock = null;
                    throw ex;
                }
                if (!st.prepare()) {
                    return;
                }
                try {
                    st.execute(this.server, this.server);
                    success = true;
                }
                catch (Exception e) {
                    block39: {
                        if (this.server.isStopping() || this.server.isStopped()) {
                            LOG.info((Object)("Skip rollback/cleanup of failed split of " + this.parent.getRegionNameAsString() + " because server is" + (this.server.isStopping() ? " stopping" : " stopped")), (Throwable)e);
                            if (this.parent.getCoprocessorHost() != null) {
                                try {
                                    this.parent.getCoprocessorHost().postCompleteSplit();
                                }
                                catch (IOException io) {
                                    LOG.error((Object)("Split failed " + this), (Throwable)RemoteExceptionHandler.checkIOException((IOException)io));
                                }
                            }
                            if (this.parent.shouldForceSplit()) {
                                this.parent.clearSplit();
                            }
                            this.releaseTableLock();
                            long endTime = EnvironmentEdgeManager.currentTimeMillis();
                            this.server.getMetrics().updateSplitTime(endTime - startTime);
                            if (success) {
                                this.server.getMetrics().incrSplitSuccess();
                                LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTimeMillis(), (long)startTime)));
                            }
                            LOG.info((Object)("Split transaction journal:\n\t" + Strings.join((CharSequence)"\n\t", st.getJournal())));
                            return;
                        }
                        try {
                            LOG.info((Object)("Running rollback/cleanup of failed split of " + this.parent.getRegionNameAsString() + "; " + e.getMessage()), (Throwable)e);
                            if (st.rollback(this.server, this.server)) {
                                LOG.info((Object)("Successful rollback of failed split of " + this.parent.getRegionNameAsString()));
                            } else {
                                this.server.abort("Abort; we got an error after point-of-no-return");
                            }
                        }
                        catch (RuntimeException ee) {
                            String msg = "Failed rollback of failed split of " + this.parent.getRegionNameAsString() + " -- aborting server";
                            LOG.info((Object)msg, (Throwable)ee);
                            this.server.abort(msg + " -- Cause: " + ee.getMessage());
                        }
                        if (this.parent.getCoprocessorHost() == null) break block39;
                        try {
                            this.parent.getCoprocessorHost().postCompleteSplit();
                        }
                        catch (IOException io) {
                            LOG.error((Object)("Split failed " + this), (Throwable)RemoteExceptionHandler.checkIOException((IOException)io));
                        }
                    }
                    if (this.parent.shouldForceSplit()) {
                        this.parent.clearSplit();
                    }
                    this.releaseTableLock();
                    long endTime = EnvironmentEdgeManager.currentTimeMillis();
                    this.server.getMetrics().updateSplitTime(endTime - startTime);
                    if (success) {
                        this.server.getMetrics().incrSplitSuccess();
                        LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTimeMillis(), (long)startTime)));
                    }
                    LOG.info((Object)("Split transaction journal:\n\t" + Strings.join((CharSequence)"\n\t", st.getJournal())));
                    return;
                    catch (IOException ex) {
                        LOG.error((Object)("Split failed " + this), (Throwable)RemoteExceptionHandler.checkIOException((IOException)ex));
                        this.server.checkFileSystem();
                        break block38;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (this.parent.getCoprocessorHost() != null) {
                    try {
                        this.parent.getCoprocessorHost().postCompleteSplit();
                    }
                    catch (IOException io) {
                        LOG.error((Object)("Split failed " + this), (Throwable)RemoteExceptionHandler.checkIOException((IOException)io));
                    }
                }
                if (this.parent.shouldForceSplit()) {
                    this.parent.clearSplit();
                }
                this.releaseTableLock();
                long endTime = EnvironmentEdgeManager.currentTimeMillis();
                this.server.getMetrics().updateSplitTime(endTime - startTime);
                if (success) {
                    this.server.getMetrics().incrSplitSuccess();
                    LOG.info((Object)("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTimeMillis(), (long)startTime)));
                }
                LOG.info((Object)("Split transaction journal:\n\t" + Strings.join((CharSequence)"\n\t", st.getJournal())));
            }
        }
    }

    protected void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.error((Object)"Could not release the table lock (something is really wrong). Aborting this server to avoid holding the lock forever.");
                this.server.abort("Abort; we got an error when releasing the table lock on " + this.parent.getRegionNameAsString());
            }
        }
    }
}

