/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.Properties;
import org.apache.pig.ExecType;
import org.apache.pig.backend.executionengine.ExecutionEngine;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRExecutionEngine;
import org.apache.pig.impl.PigContext;

public class LocalExecType
implements ExecType {
    private static final String[] modes = new String[]{"LOCAL", "MAPREDUCE_LOCAL", "MAPRED_LOCAL"};

    @Override
    public boolean accepts(Properties properties) {
        String execTypeSpecified = properties.getProperty("exectype", "").toUpperCase();
        for (String mode : modes) {
            if (!execTypeSpecified.equals(mode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExecutionEngine getExecutionEngine(PigContext pigContext) {
        return new MRExecutionEngine(pigContext);
    }

    public Class getExecutionEngineClass() {
        return MRExecutionEngine.class;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public String name() {
        return "LOCAL";
    }

    public String toString() {
        return this.name();
    }
}

