/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.thrift.IterInfo;

public class ActiveCompaction {
    private org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction tac;
    private Instance instance;

    ActiveCompaction(Instance instance, org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction tac) {
        this.tac = tac;
        this.instance = instance;
    }

    public String getTable() throws TableNotFoundException {
        return Tables.getTableName(this.instance, this.getExtent().getTableId().toString());
    }

    public KeyExtent getExtent() {
        return new KeyExtent(this.tac.getExtent());
    }

    public long getAge() {
        return this.tac.getAge();
    }

    public List<String> getInputFiles() {
        return this.tac.getInputFiles();
    }

    public String getOutputFile() {
        return this.tac.getOutputFile();
    }

    public CompactionType getType() {
        return CompactionType.valueOf(this.tac.getType().name());
    }

    public CompactionReason getReason() {
        return CompactionReason.valueOf(this.tac.getReason().name());
    }

    public String getLocalityGroup() {
        return this.tac.getLocalityGroup();
    }

    public long getEntriesRead() {
        return this.tac.getEntriesRead();
    }

    public long getEntriesWritten() {
        return this.tac.getEntriesWritten();
    }

    public List<IteratorSetting> getIterators() {
        ArrayList<IteratorSetting> ret = new ArrayList<IteratorSetting>();
        for (IterInfo ii : this.tac.getSsiList()) {
            IteratorSetting settings = new IteratorSetting(ii.getPriority(), ii.getIterName(), ii.getClassName());
            Map<String, String> options = this.tac.getSsio().get(ii.getIterName());
            settings.addOptions(options);
            ret.add(settings);
        }
        return ret;
    }

    public static enum CompactionReason {
        USER,
        SYSTEM,
        CHOP,
        IDLE,
        CLOSE;

    }

    public static enum CompactionType {
        MINOR,
        MERGE,
        MAJOR,
        FULL;

    }
}

