/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.impl.TabletServerBatchReaderIterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.log4j.Logger;

public class TabletServerBatchReader
extends ScannerOptions
implements BatchScanner {
    public static final Logger log = Logger.getLogger(TabletServerBatchReader.class);
    private String table;
    private int numThreads;
    private ExecutorService queryThreadPool;
    private Instance instance;
    private ArrayList<Range> ranges;
    private TCredentials credentials;
    private Authorizations authorizations = Constants.NO_AUTHS;
    private static int nextBatchReaderInstance = 1;
    private final int batchReaderInstance = TabletServerBatchReader.getNextBatchReaderInstance();

    private static synchronized int getNextBatchReaderInstance() {
        return nextBatchReaderInstance++;
    }

    public TabletServerBatchReader(Instance instance, TCredentials credentials, String table, Authorizations authorizations, int numQueryThreads) {
        ArgumentChecker.notNull(instance, credentials, table, authorizations);
        this.instance = instance;
        this.credentials = credentials;
        this.authorizations = authorizations;
        this.table = table;
        this.numThreads = numQueryThreads;
        this.queryThreadPool = new SimpleThreadPool(numQueryThreads, "batch scanner " + this.batchReaderInstance + "-");
        this.ranges = null;
    }

    @Override
    public void close() {
        this.queryThreadPool.shutdownNow();
    }

    protected void finalize() {
        if (!this.queryThreadPool.isShutdown()) {
            log.warn((Object)(TabletServerBatchReader.class.getSimpleName() + " not shutdown; did you forget to call close()?"));
            this.close();
        }
    }

    @Override
    public void setRanges(Collection<Range> ranges) {
        if (ranges == null || ranges.size() == 0) {
            throw new IllegalArgumentException("ranges must be non null and contain at least 1 range");
        }
        if (this.queryThreadPool.isShutdown()) {
            throw new IllegalStateException("batch reader closed");
        }
        this.ranges = new ArrayList<Range>(ranges);
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        if (this.ranges == null) {
            throw new IllegalStateException("ranges not set");
        }
        if (this.queryThreadPool.isShutdown()) {
            throw new IllegalStateException("batch reader closed");
        }
        return new TabletServerBatchReaderIterator(this.instance, this.credentials, this.table, this.authorizations, this.ranges, this.numThreads, this.queryThreadPool, this, this.timeOut);
    }
}

