/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.lib.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.mapreduce.lib.util.ConfiguratorBase;
import org.apache.accumulo.core.client.mock.MockTabletLocator;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;

public class InputConfigurator
extends ConfiguratorBase {
    public static void setInputTableName(Class<?> implementingClass, Configuration conf, String tableName) {
        ArgumentChecker.notNull(tableName);
        conf.set(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.TABLE_NAME), tableName);
    }

    public static String getInputTableName(Class<?> implementingClass, Configuration conf) {
        return conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.TABLE_NAME));
    }

    public static void setScanAuthorizations(Class<?> implementingClass, Configuration conf, Authorizations auths) {
        if (auths != null && !auths.isEmpty()) {
            conf.set(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.AUTHORIZATIONS), auths.serialize());
        }
    }

    public static Authorizations getScanAuthorizations(Class<?> implementingClass, Configuration conf) {
        String authString = conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.AUTHORIZATIONS));
        return authString == null ? Constants.NO_AUTHS : new Authorizations(authString.getBytes());
    }

    public static void setRanges(Class<?> implementingClass, Configuration conf, Collection<Range> ranges) {
        ArgumentChecker.notNull(ranges);
        ArrayList<String> rangeStrings = new ArrayList<String>(ranges.size());
        try {
            for (Range r : ranges) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                r.write(new DataOutputStream(baos));
                rangeStrings.add(new String(Base64.encodeBase64((byte[])baos.toByteArray()), Charset.forName("UTF-8")));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to encode ranges to Base64", ex);
        }
        conf.setStrings(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.RANGES), rangeStrings.toArray(new String[0]));
    }

    public static List<Range> getRanges(Class<?> implementingClass, Configuration conf) throws IOException {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String rangeString : conf.getStringCollection(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.RANGES))) {
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((byte[])rangeString.getBytes(Charset.forName("UTF-8"))));
            Range range = new Range();
            range.readFields(new DataInputStream(bais));
            ranges.add(range);
        }
        return ranges;
    }

    public static void fetchColumns(Class<?> implementingClass, Configuration conf, Collection<Pair<Text, Text>> columnFamilyColumnQualifierPairs) {
        ArgumentChecker.notNull(columnFamilyColumnQualifierPairs);
        ArrayList<String> columnStrings = new ArrayList<String>(columnFamilyColumnQualifierPairs.size());
        for (Pair<Text, Text> column : columnFamilyColumnQualifierPairs) {
            if (column.getFirst() == null) {
                throw new IllegalArgumentException("Column family can not be null");
            }
            String col = new String(Base64.encodeBase64((byte[])TextUtil.getBytes(column.getFirst())), Charset.forName("UTF-8"));
            if (column.getSecond() != null) {
                col = col + ":" + new String(Base64.encodeBase64((byte[])TextUtil.getBytes(column.getSecond())), Charset.forName("UTF-8"));
            }
            columnStrings.add(col);
        }
        conf.setStrings(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.COLUMNS), columnStrings.toArray(new String[0]));
    }

    public static Set<Pair<Text, Text>> getFetchedColumns(Class<?> implementingClass, Configuration conf) {
        HashSet<Pair<Text, Text>> columns = new HashSet<Pair<Text, Text>>();
        for (String col : conf.getStringCollection(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.COLUMNS))) {
            int idx = col.indexOf(":");
            Text cf = new Text(idx < 0 ? Base64.decodeBase64((byte[])col.getBytes(Charset.forName("UTF-8"))) : Base64.decodeBase64((byte[])col.substring(0, idx).getBytes(Charset.forName("UTF-8"))));
            Text cq = idx < 0 ? null : new Text(Base64.decodeBase64((byte[])col.substring(idx + 1).getBytes()));
            columns.add(new Pair<Text, Text>(cf, cq));
        }
        return columns;
    }

    public static void addIterator(Class<?> implementingClass, Configuration conf, IteratorSetting cfg) {
        String newIter;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            cfg.write(new DataOutputStream(baos));
            newIter = new String(Base64.encodeBase64((byte[])baos.toByteArray()), Charset.forName("UTF-8"));
            baos.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to serialize IteratorSetting");
        }
        String iterators = conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.ITERATORS));
        iterators = iterators == null || iterators.isEmpty() ? newIter : iterators.concat("," + newIter);
        conf.set(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.ITERATORS), iterators);
    }

    public static List<IteratorSetting> getIterators(Class<?> implementingClass, Configuration conf) {
        String iterators = conf.get(InputConfigurator.enumToConfKey(implementingClass, ScanOpts.ITERATORS));
        if (iterators == null || iterators.isEmpty()) {
            return new ArrayList<IteratorSetting>();
        }
        StringTokenizer tokens = new StringTokenizer(iterators, ",");
        ArrayList<IteratorSetting> list = new ArrayList<IteratorSetting>();
        try {
            while (tokens.hasMoreTokens()) {
                String itstring = tokens.nextToken();
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((byte[])itstring.getBytes()));
                list.add(new IteratorSetting(new DataInputStream(bais)));
                bais.close();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("couldn't decode iterator settings");
        }
        return list;
    }

    public static void setAutoAdjustRanges(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.AUTO_ADJUST_RANGES), enableFeature);
    }

    public static Boolean getAutoAdjustRanges(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.AUTO_ADJUST_RANGES), true);
    }

    public static void setScanIsolation(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.SCAN_ISOLATION), enableFeature);
    }

    public static Boolean isIsolated(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.SCAN_ISOLATION), false);
    }

    public static void setLocalIterators(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.USE_LOCAL_ITERATORS), enableFeature);
    }

    public static Boolean usesLocalIterators(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.USE_LOCAL_ITERATORS), false);
    }

    public static void setOfflineTableScan(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.SCAN_OFFLINE), enableFeature);
    }

    public static Boolean isOfflineScan(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.SCAN_OFFLINE), false);
    }

    public static TabletLocator getTabletLocator(Class<?> implementingClass, Configuration conf) throws TableNotFoundException {
        String instanceType = conf.get(InputConfigurator.enumToConfKey(implementingClass, ConfiguratorBase.InstanceOpts.TYPE));
        if ("MockInstance".equals(instanceType)) {
            return new MockTabletLocator();
        }
        Instance instance = InputConfigurator.getInstance(implementingClass, conf);
        String tableName = InputConfigurator.getInputTableName(implementingClass, conf);
        return TabletLocator.getInstance(instance, new Text(Tables.getTableId(instance, tableName)));
    }

    public static void validateOptions(Class<?> implementingClass, Configuration conf) throws IOException {
        if (!InputConfigurator.isConnectorInfoSet(implementingClass, conf).booleanValue()) {
            throw new IOException("Input info has not been set.");
        }
        String instanceKey = conf.get(InputConfigurator.enumToConfKey(implementingClass, ConfiguratorBase.InstanceOpts.TYPE));
        if (!"MockInstance".equals(instanceKey) && !"ZooKeeperInstance".equals(instanceKey)) {
            throw new IOException("Instance info has not been set.");
        }
        try {
            Connector c = InputConfigurator.getInstance(implementingClass, conf).getConnector(InputConfigurator.getPrincipal(implementingClass, conf), CredentialHelper.extractToken(InputConfigurator.getTokenClass(implementingClass, conf), InputConfigurator.getToken(implementingClass, conf)));
            if (!c.securityOperations().authenticateUser(InputConfigurator.getPrincipal(implementingClass, conf), CredentialHelper.extractToken(InputConfigurator.getTokenClass(implementingClass, conf), InputConfigurator.getToken(implementingClass, conf)))) {
                throw new IOException("Unable to authenticate user");
            }
            if (!c.securityOperations().hasTablePermission(InputConfigurator.getPrincipal(implementingClass, conf), InputConfigurator.getInputTableName(implementingClass, conf), TablePermission.READ)) {
                throw new IOException("Unable to access table");
            }
            if (!conf.getBoolean(InputConfigurator.enumToConfKey(implementingClass, Features.USE_LOCAL_ITERATORS), false)) {
                for (IteratorSetting iter : InputConfigurator.getIterators(implementingClass, conf)) {
                    if (c.tableOperations().testClassLoad(InputConfigurator.getInputTableName(implementingClass, conf), iter.getIteratorClass(), SortedKeyValueIterator.class.getName())) continue;
                    throw new AccumuloException("Servers are unable to load " + iter.getIteratorClass() + " as a " + SortedKeyValueIterator.class.getName());
                }
            }
        }
        catch (AccumuloException e) {
            throw new IOException(e);
        }
        catch (AccumuloSecurityException e) {
            throw new IOException(e);
        }
        catch (TableNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static enum Features {
        AUTO_ADJUST_RANGES,
        SCAN_ISOLATION,
        USE_LOCAL_ITERATORS,
        SCAN_OFFLINE;

    }

    public static enum ScanOpts {
        TABLE_NAME,
        AUTHORIZATIONS,
        RANGES,
        COLUMNS,
        ITERATORS;

    }
}

