/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.interpret.ScanInterpreter;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.accumulo.core.util.shell.commands.ScanCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.io.Text;

public class MaxRowCommand
extends ScanCommand {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        ScanInterpreter interpeter = this.getInterpreter(cl, tableName, shellState);
        Range range = this.getRange(cl, interpeter);
        Authorizations auths = this.getAuths(cl, shellState);
        Text startRow = range.getStartKey() == null ? null : range.getStartKey().getRow();
        Text endRow = range.getEndKey() == null ? null : range.getEndKey().getRow();
        try {
            Text max = shellState.getConnector().tableOperations().getMaxRow(tableName, auths, startRow, range.isStartKeyInclusive(), endRow, range.isEndKeyInclusive());
            if (max != null) {
                shellState.getReader().printString(max.toString() + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public String description() {
        return "finds the max row in a table within a given range";
    }
}

