/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.Token;
import org.apache.accumulo.core.util.shell.commands.ScanCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class SetAuthsCommand
extends Shell.Command {
    private Option userOpt;
    private Option scanOptAuths;
    private Option clearOptAuths;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException {
        String user = cl.getOptionValue(this.userOpt.getOpt(), shellState.getConnector().whoami());
        String scanOpts = cl.hasOption(this.clearOptAuths.getOpt()) ? null : cl.getOptionValue(this.scanOptAuths.getOpt());
        shellState.getConnector().securityOperations().changeUserAuthorizations(user, ScanCommand.parseAuthorizations(scanOpts));
        Shell.log.debug((Object)("Changed record-level authorizations for user " + user));
        return 0;
    }

    @Override
    public String description() {
        return "sets the maximum scan authorizations for a user";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        this.registerCompletionForUsers(root, completionSet);
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup setOrClear = new OptionGroup();
        this.scanOptAuths = new Option("s", "scan-authorizations", true, "scan authorizations to set");
        this.scanOptAuths.setArgName("comma-separated-authorizations");
        setOrClear.addOption(this.scanOptAuths);
        this.clearOptAuths = new Option("c", "clear-authorizations", false, "clear the scan authorizations");
        setOrClear.addOption(this.clearOptAuths);
        setOrClear.setRequired(true);
        o.addOptionGroup(setOrClear);
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("user");
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

