/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.monitoring.LogMonitoring;
import org.apache.hadoop.hbase.monitoring.StateDumpServlet;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class MasterDumpServlet
extends StateDumpServlet {
    private static final long serialVersionUID = 1L;
    private static final String LINE = "===========================================================";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HMaster master = (HMaster)this.getServletContext().getAttribute("master");
        assert (master != null) : "No Master in context!";
        response.setContentType("text/plain");
        ServletOutputStream os = response.getOutputStream();
        PrintWriter out = new PrintWriter((OutputStream)os);
        out.println("Master status for " + master.getServerName() + " as of " + new Date());
        out.println("\n\nVersion Info:");
        out.println(LINE);
        this.dumpVersionInfo(out);
        out.println("\n\nTasks:");
        out.println(LINE);
        TaskMonitor.get().dumpAsText(out);
        out.println("\n\nServers:");
        out.println(LINE);
        this.dumpServers(master, out);
        out.println("\n\nRegions-in-transition:");
        out.println(LINE);
        this.dumpRIT(master, out);
        out.println("\n\nExecutors:");
        out.println(LINE);
        this.dumpExecutors(master.getExecutorService(), out);
        out.println("\n\nStacks:");
        out.println(LINE);
        PrintStream ps = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");
        Threads.printThreadInfo((PrintStream)ps, (String)"");
        ps.flush();
        out.println("\n\nMaster configuration:");
        out.println(LINE);
        Configuration conf = master.getConfiguration();
        out.flush();
        conf.writeXml((OutputStream)os);
        os.flush();
        out.println("\n\nRecent regionserver aborts:");
        out.println(LINE);
        master.getRegionServerFatalLogBuffer().dumpTo(out);
        out.println("\n\nLogs");
        out.println(LINE);
        long tailKb = this.getTailKbParam(request);
        LogMonitoring.dumpTailOfLogs(out, tailKb);
        out.flush();
    }

    private void dumpRIT(HMaster master, PrintWriter out) {
        Map<String, RegionState> regionsInTransition = master.getAssignmentManager().getRegionStates().getRegionsInTransition();
        for (Map.Entry<String, RegionState> e : regionsInTransition.entrySet()) {
            String rid = e.getKey();
            RegionState rs = e.getValue();
            out.println("Region " + rid + ": " + rs.toDescriptiveString());
        }
    }

    private void dumpServers(HMaster master, PrintWriter out) {
        Map<ServerName, ServerLoad> servers = master.getServerManager().getOnlineServers();
        for (Map.Entry<ServerName, ServerLoad> e : servers.entrySet()) {
            out.println(e.getKey() + ": " + e.getValue());
        }
    }
}

