/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

import java.text.DecimalFormat;
import java.text.NumberFormat;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Bytes2Mega extends Task {
    private final NumberFormat formatter = new DecimalFormat("#0.00");
    private String property;
    private int bytes;

    public void setProperty(String property) {
        this.property = property;
    }

    public void setBytes(int bytes) {
        this.bytes = bytes;
    }

    public void execute() {
        Project project = getProject();
        double mega = bytes/(1024.*1024.);
        project.setProperty(property, formatter.format(mega));
    }
}
