/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method createAttributeNS raises a NAMESPACE_ERR if the qualifiedName has a prefix and
 * the namespaceURI is null.
 * Invoke the createAttributeNS method on a new Document object with a null value for
 * namespaceURI, and a valid qualifiedName.  Check if a NAMESPACE_ERR is thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS</a>
 */
public class documentcreateattributeNS05 {
    @Test
    void testRun() throws Throwable {
        Document newDoc;
        DocumentType docType = null;

        Attr attribute;
        String namespaceURI = null;

        String qualifiedName = "abc:def";
        Document doc = load("staffNS", false);
        DOMImplementation domImpl = doc.getImplementation();
        newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "dom:doc", docType);

        DOMException ex = assertThrows(DOMException.class, () -> newDoc.createAttributeNS(namespaceURI, qualifiedName));
        assertEquals(DOMException.NAMESPACE_ERR, ex.code, "documentcreateattributeNS05,null value for namespaceURI, and a valid qualifiedName");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentcreateattributeNS05";
    }

}
