/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The importNode method imports a node from another document to this document.
 * The returned node has no parent; (parentNode is null). The source node is not
 * altered or removed from the original document but a new copy of the source node
 * is created.
 * Using the method importNode with deep=true, import the default Attribute attribute,
 * "defaultAttr" of the second element node whose namespaceURI="http://www.nist.gov" and
 * localName="defaultAttr", into a new document.
 * Check the parentNode, nodeName, nodeType and nodeValue of the imported node to
 * verify if it has been imported correctly.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode">http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode</a>
 */
public class documentimportnode04 {
    @Test
    @Disabled
    public void testRun() throws Throwable {
        DocumentType docType = null;

        Document doc = load("staffNS", true);
        DOMImplementation domImpl = doc.getImplementation();
        Document newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "l2:root", docType);
        NodeList childList = doc.getElementsByTagNameNS("http://www.nist.gov", "employee");
        Element element = (Element) childList.item(1);
        Attr attr = element.getAttributeNode("defaultAttr");
        Node importedAttr = newDoc.importNode(attr, true);
        String nodeName = importedAttr.getNodeName();
        String nodeValue = importedAttr.getNodeValue();
        int nodeType = importedAttr.getNodeType();
        assertEquals("defaultAttr", nodeName, "documentimportnode04_nodeName");
        assertEquals(2, nodeType, "documentimportnode04_nodeType");
        assertEquals("defaultVal", nodeValue, "documentimportnode04_nodeValue");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentimportnode04";
    }

}
