/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNull;
import static org.w3c.domts.DOMTest.load;


/**
 * The importNode method imports a node from another document to this document.
 * The returned node has no parent; (parentNode is null). The source node is not
 * altered or removed from the original document but a new copy of the source node
 * is created.
 * Using the method importNode with deep=true/false, import two notaiton nodes into the
 * same and different documnet objects.  In each case check if valid public and systemids
 * are returned if any and if none, check if a null value was returned.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode">http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode</a>
 */
public class documentimportnode22 {
    @Test
    @Disabled("ER, etc")
    public void testRun() throws Throwable {
        DocumentType docTypeNull = null;

        Document doc = load("staffNS", true);
        DOMImplementation domImpl = doc.getImplementation();
        DocumentType docType = doc.getDoctype();
        Document docImp = domImpl.createDocument("http://www.w3.org/DOM/Test", "a:b", docTypeNull);
        NamedNodeMap nodeMap = docType.getNotations();
        Notation notation1 = (Notation) nodeMap.getNamedItem("notation1");
        Notation notation2 = (Notation) nodeMap.getNamedItem("notation2");
        Notation notationImp1 = (Notation) doc.importNode(notation1, true);
        Notation notationImp2 = (Notation) doc.importNode(notation2, false);
        Notation notationImpNew1 = (Notation) docImp.importNode(notation1, false);
        Notation notationImpNew2 = (Notation) docImp.importNode(notation2, true);
        String publicId1 = notation1.getPublicId();
        String publicId1Imp = notation1.getPublicId();
        String publicId1NewImp = notation1.getPublicId();
        String systemId1Imp = notation1.getSystemId();
        String systemId1NewImp = notation1.getSystemId();
        String publicId2Imp = notation2.getPublicId();
        String publicId2NewImp = notation2.getPublicId();
        String systemId2 = notation2.getSystemId();
        String systemId2Imp = notation2.getSystemId();
        String systemId2NewImp = notation2.getSystemId();
        assertEquals(publicId1, publicId1Imp, "documentimportnode22_N1PID");
        assertEquals(publicId1, publicId1NewImp, "documentimportnode22_N1NPID");
        assertNull(systemId1Imp, "documentimportnode22_N1SID");
        assertNull(systemId1NewImp, "documentimportnode22_N1NSID");
        assertEquals(systemId2, systemId2Imp, "documentimportnode22_N2SID");
        assertEquals(systemId2, systemId2NewImp, "documentimportnode22_N2NSID");
        assertNull(publicId2Imp, "documentimportnode22_N2PID");
        assertNull(publicId2Imp, "documentimportnode22_N2NPID");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentimportnode22";
    }

}
