/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.w3c.domts.DOMTest.load;


/**
 * The method "hasFeature(feature,version)" tests if the DOMImplementation implements
 * a specific feature and if so returns true.
 * Call the hasFeature method on this DOMImplementation with a combination of features
 * versions as below.  Valid feature names are case insensitive and versions "2.0",
 * "1.0" and if the version is not specified, supporting any version of the feature
 * should return true.  Check if the value returned value was true.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-5CED94D7">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-5CED94D7</a>
 */
public class domimplementationhasfeature01 {
    @Test
    void testRun() throws Throwable {
        String version = "";
        String version1 = "1.0";
        String version2 = "2.0";
        String[] featuresXML = { "XML", "xmL" };
        String[] featuresCore = { "Core", "CORE" };

        Document doc = load("staffNS", false);
        DOMImplementation domImpl = doc.getImplementation();
        boolean success;
        for (String featureXML : featuresXML) {
            assertTrue(domImpl.hasFeature(featureXML, version), "domimplementationhasfeature01_XML_1");
            assertTrue(domImpl.hasFeature(featureXML, version1), "domimplementationhasfeature01_XML_2");
        }
        for (String featureCore : featuresCore) {
            assertTrue(domImpl.hasFeature(featureCore, version), "domimplementationhasfeature01_Core_1");
            assertTrue(domImpl.hasFeature(featureCore, version1), "domimplementationhasfeature01_Core_2");
            assertTrue(domImpl.hasFeature(featureCore, version2), "domimplementationhasfeature01_Core_3");
        }
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/domimplementationhasfeature01";
    }

}
