/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.assemble.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.pluto.util.UtilityException;
import org.apache.pluto.util.assemble.AssemblerConfig;
import org.apache.pluto.util.assemble.WebXmlRewritingAssembler;

public class FileAssembler
extends WebXmlRewritingAssembler {
    public void assemble(AssemblerConfig config) throws UtilityException {
        try {
            File webappDescriptor = config.getWebappDescriptor();
            FileInputStream webXmlIn = new FileInputStream(webappDescriptor);
            File portletDescriptor = config.getPortletDescriptor();
            FileInputStream portletXmlIn = new FileInputStream(portletDescriptor);
            File destinationDescriptor = config.getDestination();
            if (webappDescriptor.equals(destinationDescriptor)) {
                File tempXml = File.createTempFile(webappDescriptor.getName() + ".", ".tmp");
                FileOutputStream webXmlOut = new FileOutputStream(tempXml);
                this.updateWebappDescriptor(webXmlIn, portletXmlIn, webXmlOut, config.getDispatchServletClass());
                destinationDescriptor.delete();
                boolean success = tempXml.renameTo(destinationDescriptor);
                if (!success) {
                    FileUtils.copyFile((File)tempXml, (File)destinationDescriptor);
                }
            } else {
                destinationDescriptor.getParentFile().mkdirs();
                FileOutputStream webXmlOut = new FileOutputStream(destinationDescriptor);
                this.updateWebappDescriptor(webXmlIn, portletXmlIn, webXmlOut, config.getDispatchServletClass());
            }
        }
        catch (IOException ex) {
            throw new UtilityException(ex.getMessage(), ex, null);
        }
    }
}

