/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.tags;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.PortletSecurityException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.VariableInfo;

public abstract class BaseURLTag
extends TagSupport {
    protected String secure = null;
    protected Boolean secureBoolean = null;
    protected String var = null;
    protected Boolean escapeXml = false;
    protected Map<String, List<String>> parametersMap = new HashMap<String, List<String>>();
    protected List<String> removedParametersList = new ArrayList<String>();
    protected Map<String, List<String>> propertiesMap = new HashMap<String, List<String>>();

    public int doStartTag() throws JspException {
        BaseURL url = this.getUrl();
        if (url == null) {
            throw new IllegalStateException("internal error: url not set");
        }
        if (this.var != null) {
            this.pageContext.removeAttribute(this.var, 1);
        }
        if (this.secure != null) {
            try {
                url.setSecure(this.getSecureBoolean());
            }
            catch (PortletSecurityException e) {
                throw new JspException((Throwable)e);
            }
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        BaseURL url = this.getUrl();
        if (url == null) {
            throw new IllegalStateException("internal error: url not set");
        }
        this.setUrlParameters(url);
        this.setUrlProperties(url);
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        String urlString = response.encodeURL(url.toString());
        if (this.escapeXml.booleanValue()) {
            urlString = this.doEscapeXml(urlString);
        }
        if (this.var == null) {
            try {
                JspWriter writer = this.pageContext.getOut();
                writer.print(urlString);
            }
            catch (IOException ioe) {
                throw new JspException("Portlet/ResourceURL-Tag Exception: cannot write to the output writer.");
            }
        } else {
            this.pageContext.setAttribute(this.var, (Object)urlString, 1);
        }
        this.propertiesMap.clear();
        this.parametersMap.clear();
        this.removedParametersList.clear();
        this.setUrl(null);
        return 6;
    }

    public void release() {
        this.secureBoolean = null;
        super.release();
    }

    public String getSecure() {
        return this.secure;
    }

    public boolean getSecureBoolean() {
        if (this.secureBoolean != null) {
            return this.secureBoolean;
        }
        return false;
    }

    public String getVar() {
        return this.var;
    }

    public Boolean getEscapeXml() {
        return this.escapeXml;
    }

    public void setSecure(String secure) {
        this.secure = secure;
        this.secureBoolean = new Boolean(secure);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setEscapeXml(Boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    protected void addParameter(String key, String value) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("the argument key must not be null or empty!");
        }
        if (value == null || value.length() == 0) {
            if (this.parametersMap.containsKey(key)) {
                this.parametersMap.remove(key);
            }
            this.removedParametersList.add(key);
        } else {
            List<String> valueList = null;
            valueList = this.parametersMap.containsKey(key) ? this.parametersMap.get(key) : new ArrayList<String>();
            valueList.add(value);
            this.parametersMap.put(key, valueList);
        }
    }

    protected void addProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        List<String> valueList = null;
        valueList = this.propertiesMap.containsKey(key) ? this.propertiesMap.get(key) : new ArrayList<String>();
        valueList.add(value);
        this.propertiesMap.put(key, valueList);
    }

    protected void setUrlParameters(BaseURL url) {
        Set<String> keySet = this.parametersMap.keySet();
        for (String key : keySet) {
            List<String> valueList = this.parametersMap.get(key);
            String[] valueArray = valueList.toArray(new String[0]);
            url.setParameter(key, valueArray);
        }
    }

    protected void setUrlProperties(BaseURL url) {
        Set<String> keySet = this.propertiesMap.keySet();
        for (String key : keySet) {
            List<String> valueList = this.propertiesMap.get(key);
            for (String value : valueList) {
                url.addProperty(key, value);
            }
        }
    }

    protected abstract BaseURL getUrl();

    protected abstract void setUrl(BaseURL var1);

    protected String doEscapeXml(String str) {
        if (!this.isEmpty(str)) {
            str = str.replaceAll("&", "&amp;");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
            str = str.replaceAll("\"", "&#034;");
            str = str.replaceAll("'", "&#039;");
        }
        return str;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static class TEI
    extends TagExtraInfo {
        public VariableInfo[] getVariableInfo(TagData tagData) {
            VariableInfo[] vi = null;
            String var = tagData.getAttributeString("var");
            if (var != null) {
                vi = new VariableInfo[]{new VariableInfo(var, "java.lang.String", true, 1)};
            }
            return vi;
        }
    }
}

