/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.driver;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.UnavailableException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.FilterManager;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.AdministrativeRequestListener;
import org.apache.pluto.container.driver.DriverPortletConfig;
import org.apache.pluto.container.driver.DriverPortletContext;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.driver.PortalAdministrationService;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.driver.PortletInvocationEvent;
import org.apache.pluto.container.driver.PortletInvocationListener;
import org.apache.pluto.container.om.portlet.PortletDefinition;

public class PortletServlet
extends HttpServlet {
    private static final long serialVersionUID = -5096339022539360365L;
    private String portletName;
    private Portlet portlet;
    private DriverPortletContext portletContext;
    private DriverPortletConfig portletConfig;
    private EventPortlet eventPortlet;
    private ResourceServingPortlet resourceServingPortlet;
    private PortletContextService contextService;
    private boolean started = false;
    Timer startTimer;

    public String getServletInfo() {
        return "Pluto PortletServlet [" + this.portletName + "]";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.portletName = this.getInitParameter("portlet-name");
        this.started = false;
        this.startTimer = new Timer(true);
        final ServletContext servletContext = this.getServletContext();
        final ClassLoader paClassLoader = Thread.currentThread().getContextClassLoader();
        this.startTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ServletContext servletContext2 = servletContext;
                synchronized (servletContext2) {
                    if (PortletServlet.this.startTimer != null && PortletServlet.this.attemptRegistration(servletContext, paClassLoader)) {
                        PortletServlet.this.startTimer.cancel();
                        PortletServlet.this.startTimer = null;
                    }
                }
            }
        }, 1L, 10000L);
    }

    protected boolean attemptRegistration(ServletContext context, ClassLoader paClassLoader) {
        if (PlutoServices.getServices() != null) {
            this.contextService = PlutoServices.getServices().getPortletContextService();
            try {
                ServletConfig sConfig = this.getServletConfig();
                if (sConfig == null) {
                    String msg = "Problem obtaining servlet configuration(getServletConfig() returns null).";
                    context.log(msg);
                    return true;
                }
                String applicationName = this.contextService.register(sConfig);
                this.started = true;
                this.portletContext = this.contextService.getPortletContext(applicationName);
                this.portletConfig = this.contextService.getPortletConfig(applicationName, this.portletName);
            }
            catch (PortletContainerException ex) {
                context.log(ex.getMessage(), (Throwable)ex);
                return true;
            }
            PortletDefinition portletDD = this.portletConfig.getPortletDefinition();
            try {
                Class<?> clazz = paClassLoader.loadClass(portletDD.getPortletClass());
                this.portlet = (Portlet)clazz.newInstance();
                this.portlet.init((PortletConfig)this.portletConfig);
                this.initializeEventPortlet();
                this.initializeResourceServingPortlet();
                return true;
            }
            catch (Exception ex) {
                context.log(ex.getMessage(), (Throwable)ex);
                this.portlet = null;
                this.portletConfig = null;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ServletContext servletContext = this.getServletContext();
        synchronized (servletContext) {
            if (this.startTimer != null) {
                this.startTimer.cancel();
                this.startTimer = null;
            } else if (this.started && this.portletContext != null) {
                this.started = false;
                this.contextService.unregister(this.portletContext);
                if (this.portlet != null) {
                    try {
                        this.portlet.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.portlet = null;
                }
            }
            super.destroy();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.portlet == null) {
            throw new javax.servlet.UnavailableException("Portlet " + this.portletName + " unavailable");
        }
        Integer methodId = (Integer)request.getAttribute("org.apache.pluto.core.method");
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        PortletRequestContext requestContext = (PortletRequestContext)portletRequest.getAttribute(PortletInvokerService.REQUEST_CONTEXT);
        PortletResponseContext responseContext = (PortletResponseContext)portletRequest.getAttribute(PortletInvokerService.RESPONSE_CONTEXT);
        FilterManager filterManager = (FilterManager)request.getAttribute("FilterManager");
        request.removeAttribute("org.apache.pluto.core.method");
        request.removeAttribute("javax.portlet.request");
        request.removeAttribute("javax.portlet.response");
        request.removeAttribute("FilterManager");
        requestContext.init((PortletConfig)this.portletConfig, this.getServletContext(), request, response);
        responseContext.init(request, response);
        PortletWindow window = requestContext.getPortletWindow();
        PortletInvocationEvent event = new PortletInvocationEvent(portletRequest, window, methodId);
        this.notify(event, true, null);
        try {
            if (methodId == PortletInvokerService.METHOD_RENDER) {
                RenderRequest renderRequest = (RenderRequest)portletRequest;
                RenderResponse renderResponse = (RenderResponse)portletResponse;
                filterManager.processFilter(renderRequest, renderResponse, this.portlet, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_RESOURCE) {
                ResourceRequest resourceRequest = (ResourceRequest)portletRequest;
                ResourceResponse resourceResponse = (ResourceResponse)portletResponse;
                filterManager.processFilter(resourceRequest, resourceResponse, this.resourceServingPortlet, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_ACTION) {
                ActionRequest actionRequest = (ActionRequest)portletRequest;
                ActionResponse actionResponse = (ActionResponse)portletResponse;
                filterManager.processFilter(actionRequest, actionResponse, this.portlet, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_EVENT) {
                EventRequest eventRequest = (EventRequest)portletRequest;
                EventResponse eventResponse = (EventResponse)portletResponse;
                filterManager.processFilter(eventRequest, eventResponse, this.eventPortlet, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_ADMIN) {
                PortalAdministrationService pas = PlutoServices.getServices().getPortalAdministrationService();
                for (AdministrativeRequestListener l : pas.getAdministrativeRequestListeners()) {
                    l.administer(portletRequest, portletResponse);
                }
            } else if (methodId == PortletInvokerService.METHOD_LOAD) {
                // empty if block
            }
            this.notify(event, false, null);
        }
        catch (UnavailableException ex) {
            try {
                this.portlet.destroy();
            }
            catch (Throwable th) {
                this.getServletContext().log("Error during portlet destroy.", th);
            }
            this.portlet = null;
            throw new javax.servlet.UnavailableException(ex.getMessage());
        }
        catch (PortletException ex) {
            this.notify(event, false, ex);
            throw new ServletException((Throwable)ex);
        }
    }

    protected void notify(PortletInvocationEvent event, boolean pre, Throwable e) {
        PortalAdministrationService pas = PlutoServices.getServices().getPortalAdministrationService();
        for (PortletInvocationListener listener : pas.getPortletInvocationListeners()) {
            if (pre) {
                listener.onBegin(event);
                continue;
            }
            if (e == null) {
                listener.onEnd(event);
                continue;
            }
            listener.onError(event, e);
        }
    }

    private void initializeEventPortlet() {
        this.eventPortlet = this.portlet instanceof EventPortlet ? (EventPortlet)this.portlet : new NullPortlet();
    }

    private void initializeResourceServingPortlet() {
        this.resourceServingPortlet = this.portlet instanceof ResourceServingPortlet ? (ResourceServingPortlet)this.portlet : new NullPortlet();
    }

    static class NullPortlet
    implements EventPortlet,
    ResourceServingPortlet,
    Portlet {
        NullPortlet() {
        }

        public void processEvent(EventRequest arg0, EventResponse arg1) throws PortletException, IOException {
        }

        public void serveResource(ResourceRequest arg0, ResourceResponse arg1) throws PortletException, IOException {
        }

        public void destroy() {
        }

        public void init(PortletConfig arg0) throws PortletException {
        }

        public void processAction(ActionRequest arg0, ActionResponse arg1) throws PortletException, IOException {
        }

        public void render(RenderRequest arg0, RenderResponse arg1) throws PortletException, IOException {
        }
    }
}

