/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.SpecializedBeanResolver;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.reflection.Reflections;

public class SpecializationAndEnablementRegistry
extends AbstractBootstrapService {
    private final LoadingCache<BeanManagerImpl, SpecializedBeanResolver> specializedBeanResolvers;
    private final Map<BeanManagerImpl, BeanDeployerEnvironment> environmentByManager = new ConcurrentHashMap<BeanManagerImpl, BeanDeployerEnvironment>();
    private final LoadingCache<Bean<?>, Set<? extends AbstractBean<?, ?>>> specializedBeans;
    private final Multiset<AbstractBean<?, ?>> specializedBeansSet = ConcurrentHashMultiset.create();

    public SpecializationAndEnablementRegistry() {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        this.specializedBeanResolvers = cacheBuilder.build(new SpecializedBeanResolverForBeanManager());
        this.specializedBeans = cacheBuilder.build(new BeansSpecializedByBean());
    }

    public Set<? extends AbstractBean<?, ?>> resolveSpecializedBeans(Bean<?> specializingBean) {
        ProducerMethod producerMethod;
        AbstractClassBean abstractClassBean;
        if (specializingBean instanceof AbstractClassBean && (abstractClassBean = (AbstractClassBean)specializingBean).isSpecializing()) {
            return LoadingCacheUtils.getCacheValue(this.specializedBeans, specializingBean);
        }
        if (specializingBean instanceof ProducerMethod && (producerMethod = (ProducerMethod)specializingBean).isSpecializing()) {
            return LoadingCacheUtils.getCacheValue(this.specializedBeans, specializingBean);
        }
        return Collections.emptySet();
    }

    public void vetoSpecializingBean(Bean<?> bean) {
        Set noLongerSpecializedBeans = (Set)this.specializedBeans.getIfPresent(bean);
        if (noLongerSpecializedBeans != null) {
            this.specializedBeans.invalidate(bean);
            for (AbstractBean noLongerSpecializedBean : noLongerSpecializedBeans) {
                this.specializedBeansSet.remove(noLongerSpecializedBean);
            }
        }
    }

    public boolean isSpecializedInAnyBeanDeployment(Bean<?> bean) {
        return this.specializedBeansSet.contains(bean);
    }

    public boolean isEnabledInAnyBeanDeployment(Bean<?> bean) {
        for (BeanManagerImpl manager : this.environmentByManager.keySet()) {
            if (!manager.isBeanEnabled(bean)) continue;
            return true;
        }
        return false;
    }

    public boolean isCandidateForLifecycleEvent(Bean<?> bean) {
        AbstractProducerBean producer;
        if (bean instanceof AbstractProducerBean && !this.isCandidateForLifecycleEvent((producer = (AbstractProducerBean)Reflections.cast(bean)).getDeclaringBean())) {
            return false;
        }
        return this.isEnabledInAnyBeanDeployment(bean) && !this.isSpecializedInAnyBeanDeployment(bean);
    }

    public void registerEnvironment(BeanManagerImpl manager, BeanDeployerEnvironment environment, boolean additionalBeanArchive) {
        if (this.specializedBeanResolvers.size() > 0L && !additionalBeanArchive) {
            throw new IllegalStateException(this.getClass().getName() + ".registerEnvironment() must not be called after specialization resolution begins");
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment must not be null");
        }
        this.environmentByManager.put(manager, environment);
    }

    @Override
    public void cleanupAfterBoot() {
        this.specializedBeanResolvers.invalidateAll();
        this.environmentByManager.clear();
        this.specializedBeans.invalidateAll();
        this.specializedBeansSet.clear();
    }

    public Set<AbstractBean<?, ?>> getBeansSpecializedInAnyDeployment() {
        return this.specializedBeansSet.elementSet();
    }

    public Multiset<AbstractBean<?, ?>> getBeansSpecializedInAnyDeploymentAsMultiset() {
        return Multisets.unmodifiableMultiset(this.specializedBeansSet);
    }

    private class BeansSpecializedByBean
    extends CacheLoader<Bean<?>, Set<? extends AbstractBean<?, ?>>> {
        private BeansSpecializedByBean() {
        }

        @Override
        public Set<? extends AbstractBean<?, ?>> load(Bean<?> specializingBean) {
            Set<AbstractBean> result = null;
            if (specializingBean instanceof AbstractClassBean) {
                result = this.apply((AbstractClassBean)specializingBean);
            }
            if (specializingBean instanceof ProducerMethod) {
                result = this.apply((ProducerMethod)specializingBean);
            }
            if (result != null) {
                if (SpecializationAndEnablementRegistry.this.isEnabledInAnyBeanDeployment(specializingBean)) {
                    SpecializationAndEnablementRegistry.this.specializedBeansSet.addAll(result);
                }
                return result;
            }
            throw new IllegalArgumentException("Unsupported bean type " + specializingBean);
        }

        private Set<AbstractClassBean<?>> apply(AbstractClassBean<?> bean) {
            return this.getSpecializedBeanResolver(bean).resolveSpecializedBeans(bean);
        }

        private Set<ProducerMethod<?, ?>> apply(ProducerMethod<?, ?> bean) {
            return this.getSpecializedBeanResolver(bean).resolveSpecializedBeans(bean);
        }

        private SpecializedBeanResolver getSpecializedBeanResolver(RIBean<?> bean) {
            return (SpecializedBeanResolver)LoadingCacheUtils.getCacheValue(SpecializationAndEnablementRegistry.this.specializedBeanResolvers, bean.getBeanManager());
        }
    }

    private class SpecializedBeanResolverForBeanManager
    extends CacheLoader<BeanManagerImpl, SpecializedBeanResolver> {
        private SpecializedBeanResolverForBeanManager() {
        }

        @Override
        public SpecializedBeanResolver load(BeanManagerImpl manager) {
            return new SpecializedBeanResolver(this.buildAccessibleBeanDeployerEnvironments(manager));
        }

        private Set<BeanDeployerEnvironment> buildAccessibleBeanDeployerEnvironments(BeanManagerImpl manager) {
            HashSet<BeanDeployerEnvironment> result = new HashSet<BeanDeployerEnvironment>();
            result.add((BeanDeployerEnvironment)SpecializationAndEnablementRegistry.this.environmentByManager.get(manager));
            this.buildAccessibleBeanDeployerEnvironments(manager, result);
            return result;
        }

        private void buildAccessibleBeanDeployerEnvironments(BeanManagerImpl manager, Collection<BeanDeployerEnvironment> result) {
            for (BeanManagerImpl accessibleManager : manager.getAccessibleManagers()) {
                BeanDeployerEnvironment environment = (BeanDeployerEnvironment)SpecializationAndEnablementRegistry.this.environmentByManager.get(accessibleManager);
                if (result.contains(environment)) continue;
                result.add(environment);
                this.buildAccessibleBeanDeployerEnvironments(accessibleManager, result);
            }
        }
    }
}

