/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.tags.el;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public abstract class ExpressionEvaluatorProxy {
    private static final Map<String, String> FACTORIES = new TreeMap<String, String>();
    private static ExpressionEvaluatorProxy proxy;

    public static ExpressionEvaluatorProxy getProxy() {
        return proxy;
    }

    private static boolean isPageContextMethodAvailable(String signature) {
        try {
            Method method = PageContext.class.getMethod(signature, new Class[0]);
            return method != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public abstract String evaluate(String var1, PageContext var2) throws JspException;

    static {
        FACTORIES.put("getELContext", "JSP21ExpressionEvaluatorProxy");
        FACTORIES.put("getExpressionEvaluator", "JSP20ExpressionEvaluatorProxy");
        FACTORIES.put("getRequest", "ApacheTaglibStandardExpressionEvaluatorProxy");
        for (Map.Entry<String, String> entry : FACTORIES.entrySet()) {
            if (!ExpressionEvaluatorProxy.isPageContextMethodAvailable(entry.getKey().toString())) continue;
            try {
                String className = ExpressionEvaluatorProxy.class.getPackage().getName() + "." + entry.getValue();
                Class<?> proxyClass = Class.forName(className);
                proxy = (ExpressionEvaluatorProxy)proxyClass.newInstance();
                if (proxy == null) continue;
                break;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to find ExpressionEvaluatorProxy '" + entry.getValue() + "'");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to access ExpressionEvaluatorProxy '" + entry.getValue() + "'");
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to instantiate ExpressionEvaluatorProxy '" + entry.getValue() + "'");
            }
        }
        if (proxy == null) {
            throw new RuntimeException("Unable to find a supported proxy");
        }
    }
}

