/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionURL;
import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.RenderParameters;
import javax.portlet.RenderURL;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletURLListenerService;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.impl.RenderParametersImpl;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.util.ArgumentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseURLImpl
implements BaseURL {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseURLImpl.class);
    private static final boolean isTrace = LOGGER.isTraceEnabled();
    protected PortletResponseContext responseContext;
    protected PortalContext portalContext;
    protected boolean filtering;
    protected boolean renderURL;
    protected final String windowId;
    protected PortletURLProvider urlProvider;

    protected BaseURLImpl(PortletResponseContext responseContext, PortletURLProvider urlProvider) {
        this.responseContext = responseContext;
        this.portalContext = responseContext.getContainer().getContainerServices().getPortalContext();
        this.windowId = responseContext.getPortletWindow().getId().getStringId();
        this.urlProvider = urlProvider;
        boolean bl = this.renderURL = PortletURLProvider.TYPE.RENDER == urlProvider.getType();
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("URL provider type=").append(urlProvider.getType());
            txt.append(", WindowId=").append(this.windowId);
            txt.append(", isRender=").append(this.renderURL);
            LOGGER.debug(txt.toString());
        }
    }

    public BaseURLImpl(PortletResponseContext responseContext, PortletURLProvider portletURLProvider, MimeResponse.Copy copy) {
        this(responseContext, portletURLProvider);
        switch (copy) {
            case NONE: {
                this.urlProvider.clearParameters(this.windowId, PortletURLProvider.ParamType.PUBLIC);
            }
            case PUBLIC: {
                this.urlProvider.clearParameters(this.windowId, PortletURLProvider.ParamType.RENDER);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterURL() {
        if (this.filtering) {
            throw new IllegalStateException("Calling PortletURL toString or write methods from a PortletURLGenerationListener not allowed");
        }
        this.filtering = true;
        try {
            PortletURLListenerService service = this.responseContext.getContainer().getContainerServices().getPortletURLListenerService();
            PortletApplicationDefinition portletApp = this.responseContext.getPortletWindow().getPortletDefinition().getApplication();
            for (PortletURLGenerationListener listener : service.getPortletURLGenerationListeners(portletApp)) {
                if (this instanceof ActionURL) {
                    listener.filterActionURL((PortletURL)((ActionURL)this));
                    continue;
                }
                if (this instanceof ResourceURL) {
                    listener.filterResourceURL((ResourceURL)this);
                    continue;
                }
                if (this instanceof RenderURL) {
                    listener.filterRenderURL((PortletURL)((RenderURL)this));
                    continue;
                }
                LOGGER.warn("Could not filter URL. Bad URL type: " + this.getClass().getSimpleName());
            }
        }
        finally {
            this.filtering = false;
        }
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        this.filterURL();
        this.urlProvider.write(out, escapeXML);
    }

    public void write(Writer out) throws IOException {
        this.write(out, true);
    }

    public String toString() {
        this.filterURL();
        return this.urlProvider.toURL();
    }

    public Appendable append(Appendable out) throws IOException {
        return this.append(out, true);
    }

    public Appendable append(Appendable out, boolean escapeXML) throws IOException {
        this.filterURL();
        this.urlProvider.append(out, escapeXML);
        return out;
    }

    public RenderParameters getRenderParameters() {
        return new RenderParametersImpl(this.urlProvider, this.windowId);
    }

    public PortletMode getPortletMode() {
        return this.urlProvider.getPortletMode();
    }

    public WindowState getWindowState() {
        return this.urlProvider.getWindowState();
    }

    public Map<String, String[]> getParameterMap() {
        String[] vals;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        Set names = this.urlProvider.getPrivateParameterNames(this.windowId);
        for (String name : names) {
            vals = this.urlProvider.getParameterValues(this.windowId, name);
            parameters.put(name, vals);
        }
        if (this.renderURL) {
            names = this.urlProvider.getPublicParameterNames(this.windowId);
            for (String name : names) {
                vals = this.urlProvider.getParameterValues(this.windowId, name);
                if (vals == null) continue;
                parameters.put(name, vals);
            }
        }
        return parameters;
    }

    public void setParameter(String name, String value) {
        ArgumentUtility.validateNotEmpty("name", name);
        if (value == null) {
            this.urlProvider.removeParameter(this.windowId, name);
        } else {
            String[] values = new String[]{value};
            this.urlProvider.setParameter(this.windowId, name, values);
        }
    }

    public void setParameter(String name, String ... values) {
        ArgumentUtility.validateNotEmpty("name", name);
        if (values == null) {
            this.urlProvider.removeParameter(this.windowId, name);
        } else {
            this.urlProvider.setParameter(this.windowId, name, (String[])values.clone());
        }
    }

    public void setParameters(Map<String, String[]> parameters) {
        ArgumentUtility.validateNotNull("parameters", parameters);
        for (String key : parameters.keySet()) {
            String[] vals = parameters.get(key);
            if (key != null && vals != null) continue;
            throw new IllegalArgumentException("parameters map contains a null key or values array");
        }
        Set currNames = this.urlProvider.getPrivateParameterNames(this.windowId);
        currNames.removeAll(parameters.keySet());
        for (String name : currNames) {
            this.urlProvider.removeParameter(this.windowId, name);
        }
        for (String key : parameters.keySet()) {
            this.urlProvider.setParameter(this.windowId, key, parameters.get(key));
        }
    }

    public void addProperty(String key, String value) {
        ArgumentUtility.validateNotEmpty("key", key);
        if (value != null) {
            Map properties = this.urlProvider.getProperties();
            ArrayList<String> values = (ArrayList<String>)properties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.urlProvider.getProperties().put(key, values);
            }
            values.add(value);
        }
    }

    public void setProperty(String key, String value) {
        ArgumentUtility.validateNotEmpty("key", key);
        Map properties = this.urlProvider.getProperties();
        if (value == null) {
            properties.remove(key);
        } else {
            ArrayList<String> values = (ArrayList<String>)properties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                properties.put(key, values);
            } else {
                values.clear();
            }
            values.add(value);
        }
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this.urlProvider.setSecure(secure);
    }
}

