/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.Enumeration;
import javax.portlet.MimeResponse;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.portlet.annotations.PortletSerializable;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.impl.BaseURLImpl;
import org.apache.pluto.container.impl.MutableRenderParametersImpl;
import org.apache.pluto.container.om.portlet.CustomPortletMode;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.util.ArgumentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortletURLImpl
extends BaseURLImpl
implements PortletURL {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortletURLImpl.class);
    private static final boolean isDebug = LOGGER.isDebugEnabled();

    public static final void load() {
        if (isDebug) {
            LOGGER.debug("Loaded.");
        }
    }

    public PortletURLImpl(PortletResponseContext responseContext, PortletURLProvider urlProvider) {
        super(responseContext, urlProvider);
    }

    public PortletURLImpl(PortletResponseContext responseContext, PortletURLProvider portletURLProvider, MimeResponse.Copy copy) {
        super(responseContext, portletURLProvider, copy);
    }

    private boolean isPortletModeAllowed(PortletMode mode) {
        if (PortletMode.VIEW.equals((Object)mode)) {
            return true;
        }
        String modeName = mode.toString();
        PortletDefinition dd = this.responseContext.getPortletWindow().getPortletDefinition();
        for (Supports sup : dd.getSupports()) {
            for (String m : sup.getPortletModes()) {
                if (!m.equalsIgnoreCase(modeName)) continue;
                CustomPortletMode cpm = dd.getApplication().getCustomPortletMode(modeName);
                if (cpm != null && !cpm.isPortalManaged()) {
                    return true;
                }
                Enumeration supportedModes = this.portalContext.getSupportedPortletModes();
                while (supportedModes.hasMoreElements()) {
                    if (!((PortletMode)supportedModes.nextElement()).equals((Object)mode)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isWindowStateAllowed(WindowState state) {
        Enumeration supportedStates = this.portalContext.getSupportedWindowStates();
        while (supportedStates.hasMoreElements()) {
            if (!((WindowState)supportedStates.nextElement()).equals((Object)state)) continue;
            return true;
        }
        return false;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        ArgumentUtility.validateNotNull("portletMode", portletMode);
        if (!this.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Can't set this PortletMode", portletMode);
        }
        this.urlProvider.setPortletMode(portletMode);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        ArgumentUtility.validateNotNull("windowState", windowState);
        if (!this.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Can't set this WindowState", windowState);
        }
        this.urlProvider.setWindowState(windowState);
    }

    public void removePublicRenderParameter(String name) {
        ArgumentUtility.validateNotEmpty("name", name);
        this.urlProvider.removePublicRenderParameter(this.windowId, name);
    }

    public MutableRenderParameters getRenderParameters() {
        return new MutableRenderParametersImpl(this.urlProvider, this.windowId);
    }

    public void setBeanParameter(PortletSerializable bean) {
        if (bean == null) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Required parameter is null.");
            txt.append(", bean: ").append(bean);
            LOGGER.info(txt.toString());
            throw new IllegalArgumentException(txt.toString());
        }
        String name = "Bob";
        if (name == null) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Given bean is not @RenderStateScoped.");
            txt.append(", bean: ").append(bean);
            LOGGER.info(txt.toString());
            throw new IllegalArgumentException(txt.toString());
        }
        this.getRenderParameters().setValues(name, bean.serialize());
    }
}

