/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsFrameBase;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.server.Constants;

public class WsFrameServer
extends WsFrameBase {
    private static final Log log = LogFactory.getLog(WsFrameServer.class);
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private final ServletInputStream sis;
    private final Object connectionReadLock = new Object();

    public WsFrameServer(ServletInputStream sis, WsSession wsSession, Transformation transformation) {
        super(wsSession, transformation);
        this.sis = sis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataAvailable() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"wsFrameServer.onDataAvailable");
        }
        Object object = this.connectionReadLock;
        synchronized (object) {
            while (this.isOpen() && this.sis.isReady()) {
                int read = this.sis.read(this.inputBuffer, this.writePos, this.inputBuffer.length - this.writePos);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("wsFrameServer.bytesRead", new Object[]{Integer.toString(read)}));
                }
                if (read == 0) {
                    return;
                }
                if (read == -1) {
                    throw new EOFException();
                }
                this.writePos += read;
                this.processInputBuffer();
            }
        }
    }

    @Override
    protected boolean isMasked() {
        return true;
    }

    @Override
    protected Transformation getTransformation() {
        return super.getTransformation();
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

