/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.mvc.Models;
import javax.mvc.engine.ViewEngineContext;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.pluto.container.bean.mvc.UriInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewEngineContextImpl
implements ViewEngineContext {
    private static final Logger LOG = LoggerFactory.getLogger(ViewEngineContextImpl.class);
    private Configuration configuration;
    private Locale locale;
    private MediaType mediaType;
    private MimeResponse mimeResponse;
    private Models models;
    private PortletRequest portletRequest;

    public ViewEngineContextImpl(Configuration configuration, PortletRequest portletRequest, MimeResponse mimeResponse, Models models, Locale locale) {
        this.configuration = configuration;
        this.portletRequest = portletRequest;
        this.mimeResponse = mimeResponse;
        this.models = models;
        this.locale = locale;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MediaType getMediaType() {
        if (this.mediaType == null) {
            String contentType = this.mimeResponse.getContentType();
            if (contentType == null) {
                this.mediaType = MediaType.TEXT_HTML_TYPE;
            } else {
                String type = contentType;
                String subtype = null;
                int pos = contentType.indexOf("/");
                if (pos > 0) {
                    type = contentType.substring(0, pos);
                    subtype = contentType.substring(pos + 1);
                }
                this.mediaType = new MediaType(type, subtype, this.mimeResponse.getCharacterEncoding());
            }
        }
        return this.mediaType;
    }

    public Models getModels() {
        return this.models;
    }

    public OutputStream getOutputStream() {
        try {
            return this.mimeResponse.getPortletOutputStream();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <T> T getRequest(Class<T> type) {
        return (T)this.portletRequest;
    }

    public ResourceInfo getResourceInfo() {
        throw new UnsupportedOperationException();
    }

    public <T> T getResponse(Class<T> type) {
        return (T)this.mimeResponse;
    }

    public MultivaluedMap<String, Object> getResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    public UriInfo getUriInfo() {
        return new UriInfoImpl();
    }

    public String getView() {
        return (String)this.portletRequest.getAttribute("viewName");
    }
}

