/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.apache.pluto.container.RequestDispatcherService;
import org.apache.pluto.container.impl.PortletRequestDispatcherImpl;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDispatcherServiceImpl
implements RequestDispatcherService {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDispatcherServiceImpl.class);

    public PortletRequestDispatcher getNamedDispatcher(ServletContext servletContext, PortletApplicationDefinition app, String name) {
        RequestDispatcher dispatcher;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Named PortletRequestDispatcher requested for name: " + name + " at context: " + app.getContextPath());
        }
        if ((dispatcher = servletContext.getNamedDispatcher(name)) != null) {
            return new PortletRequestDispatcherImpl(dispatcher, name, true);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("No matching request dispatcher found for name: " + name);
        }
        return null;
    }

    public PortletRequestDispatcher getRequestDispatcher(ServletContext servletContext, PortletApplicationDefinition app, String path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PortletRequestDispatcher requested for path: " + path + " at context: " + app.getContextPath());
        }
        if (path == null || !path.startsWith("/")) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Failed to retrieve PortletRequestDispatcher: path name must begin with a slash '/'.");
            }
            return null;
        }
        PortletRequestDispatcherImpl portletRequestDispatcher = null;
        try {
            RequestDispatcher servletRequestDispatcher = servletContext.getRequestDispatcher(path);
            if (servletRequestDispatcher != null) {
                portletRequestDispatcher = new PortletRequestDispatcherImpl(servletRequestDispatcher, path, false);
            } else if (LOG.isInfoEnabled()) {
                LOG.info("No matching request dispatcher found for: " + path);
            }
        }
        catch (Exception ex) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Failed to retrieve PortletRequestDispatcher: " + ex.getMessage());
            }
            portletRequestDispatcher = null;
        }
        return portletRequestDispatcher;
    }
}

