/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container;

public class PageResourceId
implements Comparable<PageResourceId> {
    private final String name;
    private final String scope;
    private final String version;

    public PageResourceId(String name, String scope, String version) {
        this.name = name;
        this.scope = scope;
        this.version = version;
    }

    public PageResourceId(PageResourceId other) {
        this.name = other.name;
        this.scope = other.scope;
        this.version = other.version;
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean resourceMatches(PageResourceId other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder txt = new StringBuilder(128);
        txt.append("Page resource ID. Name: ").append(this.name);
        txt.append(", Scope: ").append(this.scope);
        txt.append(", Version: ").append(this.version);
        return txt.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageResourceId other = (PageResourceId)obj;
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    @Override
    public int compareTo(PageResourceId id) {
        if (!this.equals(id)) {
            if (id == null) {
                return 1;
            }
            if (this.scope == null) {
                if (id.scope != null) {
                    return -1;
                }
            } else if (!this.scope.equals(id.scope)) {
                return this.scope.compareTo(id.scope);
            }
            if (this.name == null) {
                if (id.name != null) {
                    return -1;
                }
            } else if (!this.name.equals(id.name)) {
                return this.name.compareTo(id.name);
            }
            String currVersion = null;
            String newVersion = null;
            String[] currDecimals = new String[]{};
            String[] newDecimals = new String[]{};
            String regex = "^[vV=]{0,1}(\\d+(?:\\.\\d+){0,2}).*$";
            currVersion = this.version.replaceFirst(regex, "$1");
            newVersion = id.version.replaceFirst(regex, "$1");
            String dottedDecimalRegex = "^\\d+(?:\\.\\d+)*$";
            if (currVersion.matches(dottedDecimalRegex)) {
                if (newVersion.matches(dottedDecimalRegex)) {
                    currDecimals = currVersion.split("\\.");
                    newDecimals = newVersion.split("\\.");
                    for (int ii = 0; ii < currDecimals.length && ii < newDecimals.length; ++ii) {
                        int currDigit = Integer.parseInt(currDecimals[ii]);
                        int newDigit = Integer.parseInt(newDecimals[ii]);
                        if (newDigit > currDigit) {
                            return 1;
                        }
                        if (newDigit >= currDigit) continue;
                        return -1;
                    }
                    if (currDecimals.length > newDecimals.length) {
                        return -1;
                    }
                    if (currDecimals.length < newDecimals.length) {
                        return 1;
                    }
                }
            } else {
                if (newVersion.matches(dottedDecimalRegex)) {
                    return 1;
                }
                return this.version.compareTo(id.version);
            }
        }
        return 0;
    }
}

