/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl;

import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.DeliveryContext;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.Message;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.MessageImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;

abstract class DeliveryContextBase<T>
implements DeliveryContext<T> {
    public final MessageImpl<?, T> message;
    public final ContextInternal context;
    private final Handler<DeliveryContext>[] interceptors;
    private int interceptorIdx;
    private boolean invoking;
    private boolean invokeNext;

    protected DeliveryContextBase(MessageImpl<?, T> message, Handler<DeliveryContext>[] interceptors, ContextInternal context) {
        this.message = message;
        this.interceptors = interceptors;
        this.context = context;
        this.interceptorIdx = 0;
    }

    void dispatch() {
        this.interceptorIdx = 0;
        if (this.invoking) {
            this.invokeNext = true;
        } else {
            this.next();
        }
    }

    @Override
    public Message<T> message() {
        return this.message;
    }

    protected abstract void execute();

    @Override
    public void next() {
        if (this.invoking) {
            this.invokeNext = true;
        } else {
            while (this.interceptorIdx < this.interceptors.length) {
                Handler<DeliveryContext> interceptor = this.interceptors[this.interceptorIdx];
                this.invoking = true;
                ++this.interceptorIdx;
                if (this.context.inThread()) {
                    this.context.dispatch(this, interceptor);
                } else {
                    try {
                        interceptor.handle(this);
                    }
                    catch (Throwable t) {
                        this.context.reportException(t);
                    }
                }
                this.invoking = false;
                if (!this.invokeNext) {
                    return;
                }
                this.invokeNext = false;
            }
            this.interceptorIdx = 0;
            this.execute();
        }
    }
}

