/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Actions {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Actions.class);
    private List<Action> actions = new LinkedList<Action>();

    private Actions() {
    }

    public Actions addAction(Action action) {
        action.verifyAction();
        this.actions.add(action);
        return this;
    }

    public static Actions newBuilder() {
        return new Actions();
    }

    public int numActions() {
        return this.actions.size();
    }

    public void run() throws InterruptedException {
        for (Action action : this.actions) {
            boolean success;
            try {
                success = this.runAction(action);
            }
            catch (Exception e) {
                log.error("Uncaught exception thrown when running action [ {} ]:", (Object)action.getActionName(), (Object)e);
                success = false;
            }
            if (action.getContinueOn() == null || success == action.getContinueOn()) continue;
        }
    }

    private boolean runAction(Action action) throws InterruptedException {
        for (int i = 0; i < action.getNumRetries(); ++i) {
            ActionResult actionResult = action.getSupplier().get();
            if (actionResult.isSuccess()) {
                log.info("Successfully completed action [ {} ]", (Object)action.getActionName());
                if (action.getOnSuccess() != null) {
                    action.getOnSuccess().accept(actionResult);
                }
                return true;
            }
            if (actionResult.getErrorMsg() != null) {
                log.warn("Error completing action [ {} ] :- {} - [ATTEMPT] {}/{}", new Object[]{action.getActionName(), actionResult.getErrorMsg(), i + 1, action.getNumRetries()});
            } else {
                log.warn("Error completing action [ {} ] [ATTEMPT] {}/{}", new Object[]{action.getActionName(), i + 1, action.getNumRetries()});
            }
            Thread.sleep(action.sleepBetweenInvocationsMs);
        }
        log.error("Failed completing action [ {} ]. Giving up!", (Object)action.getActionName());
        if (action.getOnFail() != null) {
            action.getOnFail().accept(action.getSupplier().get());
        }
        return false;
    }

    public static class Action {
        private String actionName;
        private int numRetries;
        private Supplier<ActionResult> supplier;
        private long sleepBetweenInvocationsMs;
        private Boolean continueOn;
        private Consumer<ActionResult> onFail;
        private Consumer<ActionResult> onSuccess;

        public void verifyAction() {
            if (StringUtils.isBlank((CharSequence)this.actionName)) {
                throw new RuntimeException("Action name is empty!");
            }
            if (this.supplier == null) {
                throw new RuntimeException("Supplier is not specified!");
            }
        }

        @Generated
        private static int $default$numRetries() {
            return 1;
        }

        @Generated
        private static long $default$sleepBetweenInvocationsMs() {
            return 500L;
        }

        @Generated
        Action(String actionName, int numRetries, Supplier<ActionResult> supplier, long sleepBetweenInvocationsMs, Boolean continueOn, Consumer<ActionResult> onFail, Consumer<ActionResult> onSuccess) {
            this.actionName = actionName;
            this.numRetries = numRetries;
            this.supplier = supplier;
            this.sleepBetweenInvocationsMs = sleepBetweenInvocationsMs;
            this.continueOn = continueOn;
            this.onFail = onFail;
            this.onSuccess = onSuccess;
        }

        @Generated
        public static ActionBuilder builder() {
            return new ActionBuilder();
        }

        @Generated
        public ActionBuilder toBuilder() {
            return new ActionBuilder().actionName(this.actionName).numRetries(this.numRetries).supplier(this.supplier).sleepBetweenInvocationsMs(this.sleepBetweenInvocationsMs).continueOn(this.continueOn).onFail(this.onFail).onSuccess(this.onSuccess);
        }

        @Generated
        public String getActionName() {
            return this.actionName;
        }

        @Generated
        public int getNumRetries() {
            return this.numRetries;
        }

        @Generated
        public Supplier<ActionResult> getSupplier() {
            return this.supplier;
        }

        @Generated
        public long getSleepBetweenInvocationsMs() {
            return this.sleepBetweenInvocationsMs;
        }

        @Generated
        public Boolean getContinueOn() {
            return this.continueOn;
        }

        @Generated
        public Consumer<ActionResult> getOnFail() {
            return this.onFail;
        }

        @Generated
        public Consumer<ActionResult> getOnSuccess() {
            return this.onSuccess;
        }

        @Generated
        public void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Generated
        public void setNumRetries(int numRetries) {
            this.numRetries = numRetries;
        }

        @Generated
        public void setSupplier(Supplier<ActionResult> supplier) {
            this.supplier = supplier;
        }

        @Generated
        public void setSleepBetweenInvocationsMs(long sleepBetweenInvocationsMs) {
            this.sleepBetweenInvocationsMs = sleepBetweenInvocationsMs;
        }

        @Generated
        public void setContinueOn(Boolean continueOn) {
            this.continueOn = continueOn;
        }

        @Generated
        public void setOnFail(Consumer<ActionResult> onFail) {
            this.onFail = onFail;
        }

        @Generated
        public void setOnSuccess(Consumer<ActionResult> onSuccess) {
            this.onSuccess = onSuccess;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action other = (Action)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNumRetries() != other.getNumRetries()) {
                return false;
            }
            if (this.getSleepBetweenInvocationsMs() != other.getSleepBetweenInvocationsMs()) {
                return false;
            }
            Boolean this$continueOn = this.getContinueOn();
            Boolean other$continueOn = other.getContinueOn();
            if (this$continueOn == null ? other$continueOn != null : !((Object)this$continueOn).equals(other$continueOn)) {
                return false;
            }
            String this$actionName = this.getActionName();
            String other$actionName = other.getActionName();
            if (this$actionName == null ? other$actionName != null : !this$actionName.equals(other$actionName)) {
                return false;
            }
            Supplier<ActionResult> this$supplier = this.getSupplier();
            Supplier<ActionResult> other$supplier = other.getSupplier();
            if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
                return false;
            }
            Consumer<ActionResult> this$onFail = this.getOnFail();
            Consumer<ActionResult> other$onFail = other.getOnFail();
            if (this$onFail == null ? other$onFail != null : !this$onFail.equals(other$onFail)) {
                return false;
            }
            Consumer<ActionResult> this$onSuccess = this.getOnSuccess();
            Consumer<ActionResult> other$onSuccess = other.getOnSuccess();
            return !(this$onSuccess == null ? other$onSuccess != null : !this$onSuccess.equals(other$onSuccess));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Action;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNumRetries();
            long $sleepBetweenInvocationsMs = this.getSleepBetweenInvocationsMs();
            result = result * 59 + (int)($sleepBetweenInvocationsMs >>> 32 ^ $sleepBetweenInvocationsMs);
            Boolean $continueOn = this.getContinueOn();
            result = result * 59 + ($continueOn == null ? 43 : ((Object)$continueOn).hashCode());
            String $actionName = this.getActionName();
            result = result * 59 + ($actionName == null ? 43 : $actionName.hashCode());
            Supplier<ActionResult> $supplier = this.getSupplier();
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            Consumer<ActionResult> $onFail = this.getOnFail();
            result = result * 59 + ($onFail == null ? 43 : $onFail.hashCode());
            Consumer<ActionResult> $onSuccess = this.getOnSuccess();
            result = result * 59 + ($onSuccess == null ? 43 : $onSuccess.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Actions.Action(actionName=" + this.getActionName() + ", numRetries=" + this.getNumRetries() + ", supplier=" + this.getSupplier() + ", sleepBetweenInvocationsMs=" + this.getSleepBetweenInvocationsMs() + ", continueOn=" + this.getContinueOn() + ", onFail=" + this.getOnFail() + ", onSuccess=" + this.getOnSuccess() + ")";
        }

        @Generated
        public static class ActionBuilder {
            @Generated
            private String actionName;
            @Generated
            private boolean numRetries$set;
            @Generated
            private int numRetries$value;
            @Generated
            private Supplier<ActionResult> supplier;
            @Generated
            private boolean sleepBetweenInvocationsMs$set;
            @Generated
            private long sleepBetweenInvocationsMs$value;
            @Generated
            private Boolean continueOn;
            @Generated
            private Consumer<ActionResult> onFail;
            @Generated
            private Consumer<ActionResult> onSuccess;

            @Generated
            ActionBuilder() {
            }

            @Generated
            public ActionBuilder actionName(String actionName) {
                this.actionName = actionName;
                return this;
            }

            @Generated
            public ActionBuilder numRetries(int numRetries) {
                this.numRetries$value = numRetries;
                this.numRetries$set = true;
                return this;
            }

            @Generated
            public ActionBuilder supplier(Supplier<ActionResult> supplier) {
                this.supplier = supplier;
                return this;
            }

            @Generated
            public ActionBuilder sleepBetweenInvocationsMs(long sleepBetweenInvocationsMs) {
                this.sleepBetweenInvocationsMs$value = sleepBetweenInvocationsMs;
                this.sleepBetweenInvocationsMs$set = true;
                return this;
            }

            @Generated
            public ActionBuilder continueOn(Boolean continueOn) {
                this.continueOn = continueOn;
                return this;
            }

            @Generated
            public ActionBuilder onFail(Consumer<ActionResult> onFail) {
                this.onFail = onFail;
                return this;
            }

            @Generated
            public ActionBuilder onSuccess(Consumer<ActionResult> onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            @Generated
            public Action build() {
                int numRetries$value = this.numRetries$value;
                if (!this.numRetries$set) {
                    numRetries$value = Action.$default$numRetries();
                }
                long sleepBetweenInvocationsMs$value = this.sleepBetweenInvocationsMs$value;
                if (!this.sleepBetweenInvocationsMs$set) {
                    sleepBetweenInvocationsMs$value = Action.$default$sleepBetweenInvocationsMs();
                }
                return new Action(this.actionName, numRetries$value, this.supplier, sleepBetweenInvocationsMs$value, this.continueOn, this.onFail, this.onSuccess);
            }

            @Generated
            public String toString() {
                return "Actions.Action.ActionBuilder(actionName=" + this.actionName + ", numRetries$value=" + this.numRetries$value + ", supplier=" + this.supplier + ", sleepBetweenInvocationsMs$value=" + this.sleepBetweenInvocationsMs$value + ", continueOn=" + this.continueOn + ", onFail=" + this.onFail + ", onSuccess=" + this.onSuccess + ")";
            }
        }
    }

    public static class ActionResult {
        private boolean success;
        private String errorMsg;
        private Object result;

        @Generated
        ActionResult(boolean success, String errorMsg, Object result) {
            this.success = success;
            this.errorMsg = errorMsg;
            this.result = result;
        }

        @Generated
        public static ActionResultBuilder builder() {
            return new ActionResultBuilder();
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public String getErrorMsg() {
            return this.errorMsg;
        }

        @Generated
        public Object getResult() {
            return this.result;
        }

        @Generated
        public void setSuccess(boolean success) {
            this.success = success;
        }

        @Generated
        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        @Generated
        public void setResult(Object result) {
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActionResult)) {
                return false;
            }
            ActionResult other = (ActionResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$errorMsg = this.getErrorMsg();
            String other$errorMsg = other.getErrorMsg();
            if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
                return false;
            }
            Object this$result = this.getResult();
            Object other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ActionResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
            Object $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Actions.ActionResult(success=" + this.isSuccess() + ", errorMsg=" + this.getErrorMsg() + ", result=" + this.getResult() + ")";
        }

        @Generated
        public static class ActionResultBuilder {
            @Generated
            private boolean success;
            @Generated
            private String errorMsg;
            @Generated
            private Object result;

            @Generated
            ActionResultBuilder() {
            }

            @Generated
            public ActionResultBuilder success(boolean success) {
                this.success = success;
                return this;
            }

            @Generated
            public ActionResultBuilder errorMsg(String errorMsg) {
                this.errorMsg = errorMsg;
                return this;
            }

            @Generated
            public ActionResultBuilder result(Object result) {
                this.result = result;
                return this;
            }

            @Generated
            public ActionResult build() {
                return new ActionResult(this.success, this.errorMsg, this.result);
            }

            @Generated
            public String toString() {
                return "Actions.ActionResult.ActionResultBuilder(success=" + this.success + ", errorMsg=" + this.errorMsg + ", result=" + this.result + ")";
            }
        }
    }
}

