/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.MessagePayloadProcessor;
import org.apache.pulsar.common.functions.MessagePayloadProcessorConfig;
import org.apache.pulsar.common.util.ClassLoaderUtils;
import org.apache.pulsar.functions.proto.Function;

public class MessagePayloadProcessorUtils {
    public static MessagePayloadProcessor getMessagePayloadProcessorInstance(String className, Map<String, Object> configs, ClassLoader classLoader) {
        Class payloadProcessorClass;
        try {
            payloadProcessorClass = ClassLoaderUtils.loadClass((String)className, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Failed to load message payload processor class %sx", className));
        }
        try {
            if (configs == null || configs.isEmpty()) {
                Constructor ctor = payloadProcessorClass.getConstructor(new Class[0]);
                return (MessagePayloadProcessor)ctor.newInstance(new Object[0]);
            }
            Constructor ctor = payloadProcessorClass.getConstructor(Map.class);
            return (MessagePayloadProcessor)ctor.newInstance(configs);
        }
        catch (NoSuchMethodException e) {
            if (configs == null || configs.isEmpty()) {
                throw new RuntimeException("Message payload processor class does not have default constructor", e);
            }
            throw new RuntimeException("Message payload processor class does not have constructor accepts map", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create instance for message payload processor class", e);
        }
    }

    public static MessagePayloadProcessorConfig convertFromSpec(Function.MessagePayloadProcessorSpec spec) {
        if (spec == null || StringUtils.isEmpty((CharSequence)spec.getClassName())) {
            return null;
        }
        MessagePayloadProcessorConfig.MessagePayloadProcessorConfigBuilder bldr = MessagePayloadProcessorConfig.builder();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map configs = (Map)new Gson().fromJson(spec.getConfigs(), type);
        bldr.className(spec.getClassName()).config(configs);
        return bldr.build();
    }

    public static Function.MessagePayloadProcessorSpec convert(MessagePayloadProcessorConfig config) {
        Function.MessagePayloadProcessorSpec.Builder bldr = Function.MessagePayloadProcessorSpec.newBuilder().setClassName(config.getClassName());
        if (config.getConfig() != null) {
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            String readerConfigString = new Gson().toJson((Object)config.getConfig(), type);
            bldr.setConfigs(readerConfigString);
        }
        return bldr.build();
    }
}

