/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import rx.Emitter;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
final class KeyVaultFutures {
    KeyVaultFutures() {
    }

    static class KeyVaultFuture<T>
    extends ServiceFuture<T> {
        KeyVaultFuture() {
        }

        protected void setSubscription(Subscription subscription) {
            super.setSubscription(subscription);
        }

        boolean failure(Throwable t) {
            return this.setException(t);
        }
    }

    static abstract class ListCallbackObserver<TInner, T> {
        ListCallbackObserver() {
        }

        abstract void list(ListOperationCallback<TInner> var1);

        abstract Observable<T> typeConvertAsync(TInner var1);

        Observable<T> toObservable() {
            return Observable.create((Action1)new Action1<Emitter<List<TInner>>>(){

                public void call(final Emitter<List<TInner>> emitter) {
                    ListCallbackObserver.this.list(new ListOperationCallback<TInner>(){

                        public ListOperationCallback.PagingBehavior progress(List<TInner> partial) {
                            emitter.onNext(partial);
                            return ListOperationCallback.PagingBehavior.CONTINUE;
                        }

                        public void success() {
                            emitter.onCompleted();
                        }

                        public void failure(Throwable t) {
                            emitter.onError(t);
                        }
                    });
                }
            }, (Emitter.BackpressureMode)Emitter.BackpressureMode.BUFFER).flatMap(new Func1<List<TInner>, Observable<TInner>>(){

                public Observable<TInner> call(List<TInner> secretItems) {
                    return Observable.from(secretItems);
                }
            }).flatMap(new Func1<TInner, Observable<T>>(){

                public Observable<T> call(TInner tInner) {
                    return ListCallbackObserver.this.typeConvertAsync(tInner);
                }
            });
        }
    }

    static abstract class ServiceFutureConverter<TInner, T> {
        ServiceFutureConverter() {
        }

        abstract ServiceFuture<TInner> callAsync();

        abstract T wrapModel(TInner var1);

        ServiceFuture<T> toFuture(final ServiceCallback<T> callback) {
            final KeyVaultFuture future = new KeyVaultFuture();
            Observable.from(this.callAsync()).subscribe(new Action1<TInner>(){

                public void call(TInner inner) {
                    Object fluent = ServiceFutureConverter.this.wrapModel(inner);
                    if (callback != null) {
                        callback.success(fluent);
                    }
                    future.success(fluent);
                }
            }, (Action1)new Action1<Throwable>(){

                public void call(Throwable throwable) {
                    if (callback != null) {
                        callback.failure(throwable);
                    }
                    future.failure(throwable);
                }
            });
            return future;
        }

        public Observable<T> toObservable() {
            return Observable.defer((Func0)new Func0<Observable<T>>(){

                public Observable<T> call() {
                    return Observable.from(ServiceFutureConverter.this.toFuture(null));
                }
            });
        }
    }
}

