/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryApplication;
import com.microsoft.azure.management.graphrbac.CertificateCredential;
import com.microsoft.azure.management.graphrbac.PasswordCredential;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationInner;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationUpdateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.CertificateCredentialImpl;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.HasCredential;
import com.microsoft.azure.management.graphrbac.implementation.KeyCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.PasswordCredentialImpl;
import com.microsoft.azure.management.graphrbac.implementation.PasswordCredentialInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class ActiveDirectoryApplicationImpl
extends CreatableUpdatableImpl<ActiveDirectoryApplication, ApplicationInner, ActiveDirectoryApplicationImpl>
implements ActiveDirectoryApplication,
ActiveDirectoryApplication.Definition,
ActiveDirectoryApplication.Update,
HasCredential<ActiveDirectoryApplicationImpl> {
    private GraphRbacManager manager;
    private ApplicationCreateParametersInner createParameters;
    private ApplicationUpdateParametersInner updateParameters;
    private Map<String, PasswordCredential> cachedPasswordCredentials;
    private Map<String, CertificateCredential> cachedCertificateCredentials;

    ActiveDirectoryApplicationImpl(ApplicationInner innerObject, GraphRbacManager manager) {
        super(innerObject.displayName(), (Object)innerObject);
        this.manager = manager;
        this.createParameters = new ApplicationCreateParametersInner().withDisplayName(innerObject.displayName());
        this.updateParameters = new ApplicationUpdateParametersInner().withDisplayName(innerObject.displayName());
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Observable<ActiveDirectoryApplication> createResourceAsync() {
        if (this.createParameters.identifierUris() == null) {
            this.createParameters.withIdentifierUris(new ArrayList<String>());
            this.createParameters.identifierUris().add(this.createParameters.homepage());
        }
        return this.manager.inner().applications().createAsync(this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap((Func1)new Func1<ActiveDirectoryApplication, Observable<ActiveDirectoryApplication>>(){

            public Observable<ActiveDirectoryApplication> call(ActiveDirectoryApplication application) {
                return ActiveDirectoryApplicationImpl.this.refreshCredentialsAsync();
            }
        });
    }

    public Observable<ActiveDirectoryApplication> updateResourceAsync() {
        return this.manager.inner().applications().patchAsync(this.id(), this.updateParameters).flatMap((Func1)new Func1<Void, Observable<ActiveDirectoryApplication>>(){

            public Observable<ActiveDirectoryApplication> call(Void aVoid) {
                return ActiveDirectoryApplicationImpl.this.refreshAsync();
            }
        });
    }

    Observable<ActiveDirectoryApplication> refreshCredentialsAsync() {
        Observable keyCredentials = this.manager.inner().applications().listKeyCredentialsAsync(this.id()).flatMapIterable((Func1)new Func1<List<KeyCredentialInner>, Iterable<KeyCredentialInner>>(){

            public Iterable<KeyCredentialInner> call(List<KeyCredentialInner> keyCredentialInners) {
                return keyCredentialInners;
            }
        }).map((Func1)new Func1<KeyCredentialInner, CertificateCredential>(){

            public CertificateCredential call(KeyCredentialInner keyCredentialInner) {
                return new CertificateCredentialImpl(keyCredentialInner);
            }
        }).toMap((Func1)new Func1<CertificateCredential, String>(){

            public String call(CertificateCredential certificateCredential) {
                return certificateCredential.name();
            }
        }).map((Func1)new Func1<Map<String, CertificateCredential>, ActiveDirectoryApplication>(){

            public ActiveDirectoryApplication call(Map<String, CertificateCredential> stringCertificateCredentialMap) {
                ActiveDirectoryApplicationImpl.this.cachedCertificateCredentials = stringCertificateCredentialMap;
                return ActiveDirectoryApplicationImpl.this;
            }
        });
        Observable passwordCredentials = this.manager.inner().applications().listPasswordCredentialsAsync(this.id()).flatMapIterable((Func1)new Func1<List<PasswordCredentialInner>, Iterable<PasswordCredentialInner>>(){

            public Iterable<PasswordCredentialInner> call(List<PasswordCredentialInner> passwordCredentialInners) {
                return passwordCredentialInners;
            }
        }).map((Func1)new Func1<PasswordCredentialInner, PasswordCredential>(){

            public PasswordCredential call(PasswordCredentialInner passwordCredentialInner) {
                return new PasswordCredentialImpl(passwordCredentialInner);
            }
        }).toMap((Func1)new Func1<PasswordCredential, String>(){

            public String call(PasswordCredential passwordCredential) {
                return passwordCredential.name();
            }
        }).map((Func1)new Func1<Map<String, PasswordCredential>, ActiveDirectoryApplication>(){

            public ActiveDirectoryApplication call(Map<String, PasswordCredential> stringPasswordCredentialMap) {
                ActiveDirectoryApplicationImpl.this.cachedPasswordCredentials = stringPasswordCredentialMap;
                return ActiveDirectoryApplicationImpl.this;
            }
        });
        return keyCredentials.mergeWith(passwordCredentials).last();
    }

    public Observable<ActiveDirectoryApplication> refreshAsync() {
        return this.getInnerAsync().map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap((Func1)new Func1<ActiveDirectoryApplication, Observable<ActiveDirectoryApplication>>(){

            public Observable<ActiveDirectoryApplication> call(ActiveDirectoryApplication application) {
                return ActiveDirectoryApplicationImpl.this.refreshCredentialsAsync();
            }
        });
    }

    public String id() {
        return ((ApplicationInner)this.inner()).objectId();
    }

    @Override
    public String applicationId() {
        return ((ApplicationInner)this.inner()).appId();
    }

    @Override
    public List<String> applicationPermissions() {
        if (((ApplicationInner)this.inner()).appPermissions() == null) {
            return null;
        }
        return Collections.unmodifiableList(((ApplicationInner)this.inner()).appPermissions());
    }

    @Override
    public boolean availableToOtherTenants() {
        return ((ApplicationInner)this.inner()).availableToOtherTenants();
    }

    @Override
    public Set<String> identifierUris() {
        if (((ApplicationInner)this.inner()).identifierUris() == null) {
            return null;
        }
        return Collections.unmodifiableSet(Sets.newHashSet(((ApplicationInner)this.inner()).identifierUris()));
    }

    @Override
    public Set<String> replyUrls() {
        if (((ApplicationInner)this.inner()).replyUrls() == null) {
            return null;
        }
        return Collections.unmodifiableSet(Sets.newHashSet(((ApplicationInner)this.inner()).replyUrls()));
    }

    @Override
    public URL signOnUrl() {
        try {
            return new URL(((ApplicationInner)this.inner()).homepage());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public Map<String, PasswordCredential> passwordCredentials() {
        if (this.cachedPasswordCredentials == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.cachedPasswordCredentials);
    }

    @Override
    public Map<String, CertificateCredential> certificateCredentials() {
        if (this.cachedCertificateCredentials == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.cachedCertificateCredentials);
    }

    protected Observable<ApplicationInner> getInnerAsync() {
        return this.manager.inner().applications().getAsync(this.id());
    }

    @Override
    public ActiveDirectoryApplicationImpl withSignOnUrl(String signOnUrl) {
        if (this.isInCreateMode()) {
            this.createParameters.withHomepage(signOnUrl);
        } else {
            this.updateParameters.withHomepage(signOnUrl);
        }
        return this.withReplyUrl(signOnUrl);
    }

    @Override
    public ActiveDirectoryApplicationImpl withReplyUrl(String replyUrl) {
        if (this.isInCreateMode()) {
            if (this.createParameters.replyUrls() == null) {
                this.createParameters.withReplyUrls(new ArrayList<String>());
            }
            this.createParameters.replyUrls().add(replyUrl);
        } else {
            if (this.updateParameters.replyUrls() == null) {
                this.updateParameters.withReplyUrls(new ArrayList<String>(this.replyUrls()));
            }
            this.updateParameters.replyUrls().add(replyUrl);
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withoutReplyUrl(String replyUrl) {
        if (this.updateParameters.replyUrls() != null) {
            this.updateParameters.replyUrls().remove(replyUrl);
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withIdentifierUrl(String identifierUrl) {
        if (this.isInCreateMode()) {
            if (this.createParameters.identifierUris() == null) {
                this.createParameters.withIdentifierUris(new ArrayList<String>());
            }
            this.createParameters.identifierUris().add(identifierUrl);
        } else {
            if (this.updateParameters.identifierUris() == null) {
                this.updateParameters.withIdentifierUris(new ArrayList<String>(this.identifierUris()));
            }
            this.updateParameters.identifierUris().add(identifierUrl);
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplication.Update withoutIdentifierUrl(String identifierUrl) {
        if (this.updateParameters.identifierUris() != null) {
            this.updateParameters.identifierUris().remove(identifierUrl);
        }
        return this;
    }

    public CertificateCredentialImpl defineCertificateCredential(String name) {
        return new CertificateCredentialImpl(name, this);
    }

    public PasswordCredentialImpl definePasswordCredential(String name) {
        return new PasswordCredentialImpl(name, this);
    }

    @Override
    public ActiveDirectoryApplicationImpl withoutCredential(String name) {
        if (this.cachedPasswordCredentials.containsKey(name)) {
            this.cachedPasswordCredentials.remove(name);
            this.updateParameters.withPasswordCredentials(Lists.transform(new ArrayList<PasswordCredential>(this.cachedPasswordCredentials.values()), (Function)new Function<PasswordCredential, PasswordCredentialInner>(){

                public PasswordCredentialInner apply(PasswordCredential input) {
                    return (PasswordCredentialInner)input.inner();
                }
            }));
        } else if (this.cachedCertificateCredentials.containsKey(name)) {
            this.cachedCertificateCredentials.remove(name);
            this.updateParameters.withKeyCredentials(Lists.transform(new ArrayList<CertificateCredential>(this.cachedCertificateCredentials.values()), (Function)new Function<CertificateCredential, KeyCredentialInner>(){

                public KeyCredentialInner apply(CertificateCredential input) {
                    return (KeyCredentialInner)input.inner();
                }
            }));
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withCertificateCredential(CertificateCredentialImpl<?> credential) {
        if (this.isInCreateMode()) {
            if (this.createParameters.keyCredentials() == null) {
                this.createParameters.withKeyCredentials(new ArrayList<KeyCredentialInner>());
            }
            this.createParameters.keyCredentials().add((KeyCredentialInner)credential.inner());
        } else {
            if (this.updateParameters.keyCredentials() == null) {
                this.updateParameters.withKeyCredentials(new ArrayList<KeyCredentialInner>());
            }
            this.updateParameters.keyCredentials().add((KeyCredentialInner)credential.inner());
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withPasswordCredential(PasswordCredentialImpl<?> credential) {
        if (this.isInCreateMode()) {
            if (this.createParameters.passwordCredentials() == null) {
                this.createParameters.withPasswordCredentials(new ArrayList<PasswordCredentialInner>());
            }
            this.createParameters.passwordCredentials().add((PasswordCredentialInner)credential.inner());
        } else {
            if (this.updateParameters.passwordCredentials() == null) {
                this.updateParameters.withPasswordCredentials(new ArrayList<PasswordCredentialInner>());
            }
            this.updateParameters.passwordCredentials().add((PasswordCredentialInner)credential.inner());
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withAvailableToOtherTenants(boolean availableToOtherTenants) {
        if (this.isInCreateMode()) {
            this.createParameters.withAvailableToOtherTenants(availableToOtherTenants);
        } else {
            this.updateParameters.withAvailableToOtherTenants(availableToOtherTenants);
        }
        return this;
    }

    public GraphRbacManager manager() {
        return this.manager;
    }
}

