/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.sql.SqlFirewallRule;
import com.microsoft.azure.management.sql.SqlFirewallRuleOperations;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.FirewallRuleInner;
import com.microsoft.azure.management.sql.implementation.SqlFirewallRuleImpl;
import com.microsoft.azure.management.sql.implementation.SqlFirewallRulesAsExternalChildResourcesImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlFirewallRuleOperationsImpl
implements SqlFirewallRuleOperations,
SqlFirewallRuleOperations.SqlFirewallRuleActionsDefinition {
    private SqlServerManager sqlServerManager;
    private SqlServer sqlServer;
    private SqlFirewallRulesAsExternalChildResourcesImpl sqlFirewallRules;

    SqlFirewallRuleOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServer = parent;
        this.sqlServerManager = sqlServerManager;
        this.sqlFirewallRules = new SqlFirewallRulesAsExternalChildResourcesImpl(sqlServerManager, "SqlFirewallRule");
    }

    SqlFirewallRuleOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.sqlFirewallRules = new SqlFirewallRulesAsExternalChildResourcesImpl(sqlServerManager, "SqlFirewallRule");
    }

    @Override
    public SqlFirewallRule getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        FirewallRuleInner inner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().get(resourceGroupName, sqlServerName, name);
        return inner != null ? new SqlFirewallRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlFirewallRule> getBySqlServerAsync(final String resourceGroupName, final String sqlServerName, String name) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().getAsync(resourceGroupName, sqlServerName, name).map((Func1)new Func1<FirewallRuleInner, SqlFirewallRule>(){

            public SqlFirewallRule call(FirewallRuleInner inner) {
                return new SqlFirewallRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, SqlFirewallRuleOperationsImpl.this.sqlServerManager);
            }
        });
    }

    @Override
    public SqlFirewallRule getBySqlServer(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        FirewallRuleInner inner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return inner != null ? new SqlFirewallRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Observable<SqlFirewallRule> getBySqlServerAsync(final SqlServer sqlServer, final String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map((Func1)new Func1<FirewallRuleInner, SqlFirewallRule>(){

            public SqlFirewallRule call(FirewallRuleInner inner) {
                return new SqlFirewallRuleImpl(name, (SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager()));
            }
        });
    }

    @Override
    public SqlFirewallRule get(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlServer, name);
    }

    @Override
    public Observable<SqlFirewallRule> getAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer, name);
    }

    @Override
    public SqlFirewallRule getById(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Observable<SqlFirewallRule> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Completable deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().deleteAsync(resourceGroupName, sqlServerName, name).toCompletable();
    }

    @Override
    public void deleteById(String id) {
        Objects.requireNonNull(id);
        this.deleteBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.deleteBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public void delete(String name) {
        if (this.sqlServer != null) {
            this.deleteBySqlServer(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
        }
    }

    @Override
    public Completable deleteAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.deleteBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
    }

    @Override
    public List<SqlFirewallRule> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlFirewallRuleImpl> firewallRuleSet = new ArrayList<SqlFirewallRuleImpl>();
        List<FirewallRuleInner> firewallRuleInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().listByServer(resourceGroupName, sqlServerName);
        if (firewallRuleInners != null) {
            for (FirewallRuleInner inner : firewallRuleInners) {
                firewallRuleSet.add(new SqlFirewallRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(firewallRuleSet);
    }

    @Override
    public Observable<SqlFirewallRule> listBySqlServerAsync(final String resourceGroupName, final String sqlServerName) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().listByServerAsync(resourceGroupName, sqlServerName).flatMap((Func1)new Func1<List<FirewallRuleInner>, Observable<FirewallRuleInner>>(){

            public Observable<FirewallRuleInner> call(List<FirewallRuleInner> firewallRuleInners) {
                return Observable.from(firewallRuleInners);
            }
        }).map((Func1)new Func1<FirewallRuleInner, SqlFirewallRule>(){

            public SqlFirewallRule call(FirewallRuleInner inner) {
                return new SqlFirewallRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, SqlFirewallRuleOperationsImpl.this.sqlServerManager);
            }
        });
    }

    @Override
    public List<SqlFirewallRule> listBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        ArrayList<SqlFirewallRuleImpl> firewallRuleSet = new ArrayList<SqlFirewallRuleImpl>();
        for (FirewallRuleInner inner : ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).firewallRules().listByServer(sqlServer.resourceGroupName(), sqlServer.name())) {
            firewallRuleSet.add(new SqlFirewallRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager())));
        }
        return Collections.unmodifiableList(firewallRuleSet);
    }

    @Override
    public Observable<SqlFirewallRule> listBySqlServerAsync(final SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).firewallRules().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()).flatMap((Func1)new Func1<List<FirewallRuleInner>, Observable<FirewallRuleInner>>(){

            public Observable<FirewallRuleInner> call(List<FirewallRuleInner> firewallRuleInners) {
                return Observable.from(firewallRuleInners);
            }
        }).map((Func1)new Func1<FirewallRuleInner, SqlFirewallRule>(){

            public SqlFirewallRule call(FirewallRuleInner inner) {
                return new SqlFirewallRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager()));
            }
        });
    }

    @Override
    public List<SqlFirewallRule> list() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServer(this.sqlServer);
    }

    @Override
    public Observable<SqlFirewallRule> listAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name());
    }

    @Override
    public SqlFirewallRuleImpl define(String name) {
        SqlFirewallRuleImpl result = this.sqlFirewallRules.defineIndependentFirewallRule(name);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }
}

