/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.function.LongFunction;
import org.apache.ratis.client.DataStreamClientRpc;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.impl.DataStreamPacketByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestFilePositionCount;
import org.apache.ratis.io.FilePositionCount;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SlidingWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedStreamAsync {
    public static final Logger LOG = LoggerFactory.getLogger(OrderedStreamAsync.class);
    private final DataStreamClientRpc dataStreamClientRpc;
    private final Semaphore requestSemaphore;

    OrderedStreamAsync(DataStreamClientRpc dataStreamClientRpc, RaftProperties properties) {
        this.dataStreamClientRpc = dataStreamClientRpc;
        this.requestSemaphore = new Semaphore(RaftClientConfigKeys.DataStream.outstandingRequestsMax(properties));
    }

    CompletableFuture<DataStreamReply> sendRequest(DataStreamRequestHeader header, Object data, SlidingWindow.Client<DataStreamWindowRequest, DataStreamReply> slidingWindow) {
        try {
            this.requestSemaphore.acquire();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            return JavaUtils.completeExceptionally(IOUtils.toInterruptedIOException("Interrupted when sending " + JavaUtils.getClassSimpleName(data.getClass()) + ", header= " + header, e2));
        }
        LOG.debug("sendRequest {}, data={}", (Object)header, data);
        LongFunction<DataStreamWindowRequest> constructor = seqNum -> new DataStreamWindowRequest(header, data, seqNum);
        return slidingWindow.submitNewRequest(constructor, r -> this.sendRequestToNetwork((DataStreamWindowRequest)r, slidingWindow)).getReplyFuture().whenComplete((r, e) -> {
            if (e != null) {
                LOG.error("Failed to send request, header=" + header, (Throwable)e);
            }
            this.requestSemaphore.release();
        });
    }

    private void sendRequestToNetwork(DataStreamWindowRequest request, SlidingWindow.Client<DataStreamWindowRequest, DataStreamReply> slidingWindow) {
        CompletableFuture<DataStreamReply> f = request.getReplyFuture();
        if (f.isDone()) {
            return;
        }
        if (slidingWindow.isFirst(request.getSeqNum())) {
            request.setFirstRequest();
        }
        CompletableFuture<DataStreamReply> requestFuture = this.dataStreamClientRpc.streamAsync(request.getDataStreamRequest());
        long seqNum = request.getSeqNum();
        ((CompletableFuture)((CompletableFuture)requestFuture.thenApply(reply -> {
            slidingWindow.receiveReply(seqNum, (DataStreamReply)reply, r -> this.sendRequestToNetwork((DataStreamWindowRequest)r, slidingWindow));
            return reply;
        })).thenAccept(reply -> {
            if (f.isDone()) {
                return;
            }
            f.complete((DataStreamReply)reply);
        })).exceptionally(e -> {
            f.completeExceptionally((Throwable)e);
            return null;
        });
    }

    static class DataStreamWindowRequest
    implements SlidingWindow.ClientSideRequest<DataStreamReply> {
        private final DataStreamRequestHeader header;
        private final Object data;
        private final long seqNum;
        private final CompletableFuture<DataStreamReply> replyFuture = new CompletableFuture();

        DataStreamWindowRequest(DataStreamRequestHeader header, Object data, long seqNum) {
            this.header = header;
            this.data = data;
            this.seqNum = seqNum;
        }

        DataStreamRequest getDataStreamRequest() {
            if (this.header.getDataLength() == 0L) {
                return new DataStreamRequestByteBuffer(this.header, DataStreamPacketByteBuffer.EMPTY_BYTE_BUFFER);
            }
            if (this.data instanceof ByteBuffer) {
                return new DataStreamRequestByteBuffer(this.header, (ByteBuffer)this.data);
            }
            if (this.data instanceof FilePositionCount) {
                return new DataStreamRequestFilePositionCount(this.header, (FilePositionCount)this.data);
            }
            throw new IllegalStateException("Unexpected " + this.data.getClass());
        }

        @Override
        public void setFirstRequest() {
        }

        @Override
        public long getSeqNum() {
            return this.seqNum;
        }

        @Override
        public void setReply(DataStreamReply dataStreamReply) {
            this.replyFuture.complete(dataStreamReply);
        }

        @Override
        public boolean hasReply() {
            return this.replyFuture.isDone();
        }

        @Override
        public void fail(Throwable e) {
            this.replyFuture.completeExceptionally(e);
        }

        public CompletableFuture<DataStreamReply> getReplyFuture() {
            return this.replyFuture;
        }

        public String toString() {
            return JavaUtils.getClassSimpleName(this.getClass()) + ":seqNum=" + this.seqNum + "," + this.header;
        }
    }
}

