/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RoleInfo;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SnapshotInstallationHandler {
    static final Logger LOG = LoggerFactory.getLogger(SnapshotInstallationHandler.class);
    static final TermIndex INVALID_TERM_INDEX = TermIndex.valueOf(0L, -1L);
    private final RaftServerImpl server;
    private final ServerState state;
    private final boolean installSnapshotEnabled;
    private final AtomicLong inProgressInstallSnapshotIndex = new AtomicLong(-1L);
    private final AtomicReference<TermIndex> installedSnapshotTermIndex = new AtomicReference<TermIndex>(INVALID_TERM_INDEX);
    private final AtomicBoolean isSnapshotNull = new AtomicBoolean();
    private final AtomicLong installedIndex = new AtomicLong(-1L);
    private final AtomicInteger nextChunkIndex = new AtomicInteger(-1);
    private final AtomicLong chunk0CallId = new AtomicLong(-1L);

    SnapshotInstallationHandler(RaftServerImpl server, RaftProperties properties) {
        this.server = server;
        this.state = server.getState();
        this.installSnapshotEnabled = RaftServerConfigKeys.Log.Appender.installSnapshotEnabled(properties);
    }

    RaftGroupMemberId getMemberId() {
        return this.state.getMemberId();
    }

    long getInstalledIndex() {
        return this.installedIndex.getAndSet(-1L);
    }

    long getInProgressInstallSnapshotIndex() {
        return this.inProgressInstallSnapshotIndex.get();
    }

    RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.InstallSnapshotReplyProto reply;
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: receive installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerStringUtils.toInstallSnapshotRequestString(request));
        }
        try {
            reply = this.installSnapshotImpl(request);
        }
        catch (Exception e) {
            LOG.error("{}: installSnapshot failed", (Object)this.getMemberId(), (Object)e);
            throw e;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: reply installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerStringUtils.toInstallSnapshotReplyString(reply));
        }
        return reply;
    }

    private RaftProtos.InstallSnapshotReplyProto installSnapshotImpl(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.RaftRpcRequestProto r = request.getServerRequest();
        RaftPeerId leaderId = RaftPeerId.valueOf(r.getRequestorId());
        RaftGroupId leaderGroupId = ProtoUtils.toRaftGroupId(r.getRaftGroupId());
        CodeInjectionForTesting.execute(RaftServerImpl.INSTALL_SNAPSHOT, this.server.getId(), leaderId, request);
        this.server.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
        ServerImplUtils.assertGroup(this.getMemberId(), leaderId, leaderGroupId);
        RaftProtos.InstallSnapshotReplyProto reply = null;
        if (this.installSnapshotEnabled) {
            if (request.hasSnapshotChunk()) {
                reply = this.checkAndInstallSnapshot(request, leaderId).join();
            }
        } else if (request.hasNotification()) {
            reply = this.notifyStateMachineToInstallSnapshot(request, leaderId).join();
        }
        if (reply != null) {
            if (request.hasLastRaftConfigurationLogEntryProto()) {
                RaftProtos.LogEntryProto proto = request.getLastRaftConfigurationLogEntryProto();
                this.state.truncate(proto.getIndex());
                if (!this.state.getRaftConf().equals(LogProtoUtils.toRaftConfiguration(proto))) {
                    LOG.info("{}: set new configuration {} from snapshot", (Object)this.getMemberId(), (Object)proto);
                    this.state.setRaftConf(proto);
                    this.state.writeRaftConfiguration(proto);
                    this.server.getStateMachine().event().notifyConfigurationChanged(proto.getTerm(), proto.getIndex(), proto.getConfigurationEntry());
                }
            }
            return reply;
        }
        RaftProtos.InstallSnapshotReplyProto failedReply = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), this.state.getCurrentTerm(), RaftProtos.InstallSnapshotResult.CONF_MISMATCH);
        LOG.error("{}: Configuration Mismatch ({}): Leader {} has it set to {} but follower {} has it set to {}", this.getMemberId(), "raft.server.log.appender.install.snapshot.enabled", leaderId, request.hasSnapshotChunk(), this.server.getId(), this.installSnapshotEnabled);
        return failedReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private CompletableFuture<RaftProtos.InstallSnapshotReplyProto> checkAndInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        CompletableFuture<Void> future;
        long currentTerm;
        long leaderTerm = request.getLeaderTerm();
        RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto snapshotChunkRequest = request.getSnapshotChunk();
        TermIndex lastIncluded = TermIndex.valueOf(snapshotChunkRequest.getTermIndex());
        long lastIncludedIndex = lastIncluded.getIndex();
        RaftServerImpl raftServerImpl = this.server;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader((Object)RaftServerProtocol.Op.INSTALL_SNAPSHOT, leaderId, leaderTerm);
            currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                return CompletableFuture.completedFuture(ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, snapshotChunkRequest.getRequestIndex(), RaftProtos.InstallSnapshotResult.NOT_LEADER));
            }
            future = this.server.changeToFollowerAndPersistMetadata(leaderTerm, true, "installSnapshot");
            this.state.setLeader(leaderId, "installSnapshot");
            this.server.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_START);
            long callId = this.chunk0CallId.get();
            if (callId > request.getServerRequest().getCallId() && currentTerm == leaderTerm) {
                LOG.warn("{}: Snapshot Request Staled: chunk 0 callId is {} but {}", this.getMemberId(), callId, ServerStringUtils.toInstallSnapshotRequestString(request));
                RaftProtos.InstallSnapshotReplyProto reply = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, snapshotChunkRequest.getRequestIndex(), RaftProtos.InstallSnapshotResult.SNAPSHOT_EXPIRED);
                return future.thenApply(dummy -> reply);
            }
            if (snapshotChunkRequest.getRequestIndex() == 0) {
                this.nextChunkIndex.set(0);
                this.chunk0CallId.set(request.getServerRequest().getCallId());
            } else if (this.nextChunkIndex.get() != snapshotChunkRequest.getRequestIndex()) {
                throw new IOException("Snapshot request already failed at chunk index " + this.nextChunkIndex.get() + "; ignoring request with chunk index " + snapshotChunkRequest.getRequestIndex());
            }
            try {
                if (this.state.getLog().getLastCommittedIndex() >= lastIncludedIndex) {
                    this.nextChunkIndex.set(snapshotChunkRequest.getRequestIndex() + 1);
                    RaftProtos.InstallSnapshotReplyProto reply = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, snapshotChunkRequest.getRequestIndex(), RaftProtos.InstallSnapshotResult.ALREADY_INSTALLED);
                    CompletionStage completionStage = future.thenApply(dummy -> reply);
                    return completionStage;
                }
                this.state.installSnapshot(request);
                int expectedChunkIndex = this.nextChunkIndex.getAndIncrement();
                if (expectedChunkIndex != snapshotChunkRequest.getRequestIndex()) {
                    throw new IOException("Unexpected request chunk index: " + snapshotChunkRequest.getRequestIndex() + " (the expected index is " + expectedChunkIndex + ")");
                }
                if (snapshotChunkRequest.getDone()) {
                    this.state.reloadStateMachine(lastIncluded);
                    this.chunk0CallId.set(-1L);
                }
            }
            finally {
                this.server.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_COMPLETE);
            }
        }
        if (snapshotChunkRequest.getDone()) {
            LOG.info("{}: successfully install the entire snapshot-{}", (Object)this.getMemberId(), (Object)lastIncludedIndex);
        }
        RaftProtos.InstallSnapshotReplyProto reply = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, snapshotChunkRequest.getRequestIndex(), RaftProtos.InstallSnapshotResult.SUCCESS);
        return future.thenApply(dummy -> reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftProtos.InstallSnapshotReplyProto> notifyStateMachineToInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        long leaderTerm = request.getLeaderTerm();
        TermIndex firstAvailableLogTermIndex = TermIndex.valueOf(request.getNotification().getFirstAvailableTermIndex());
        long firstAvailableLogIndex = firstAvailableLogTermIndex.getIndex();
        RaftServerImpl raftServerImpl = this.server;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader("notifyInstallSnapshot", leaderId, leaderTerm);
            long currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                return CompletableFuture.completedFuture(ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, RaftProtos.InstallSnapshotResult.NOT_LEADER));
            }
            CompletableFuture<Void> future = this.server.changeToFollowerAndPersistMetadata(leaderTerm, true, "installSnapshot");
            this.state.setLeader(leaderId, "installSnapshot");
            this.server.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_NOTIFICATION);
            if (this.inProgressInstallSnapshotIndex.compareAndSet(-1L, firstAvailableLogIndex)) {
                LOG.info("{}: Received notification to install snapshot at index {}", (Object)this.getMemberId(), (Object)firstAvailableLogIndex);
                long snapshotIndex = this.state.getLog().getSnapshotIndex();
                if (snapshotIndex != -1L && snapshotIndex + 1L >= firstAvailableLogIndex && firstAvailableLogIndex > -1L) {
                    this.inProgressInstallSnapshotIndex.compareAndSet(firstAvailableLogIndex, -1L);
                    LOG.info("{}: InstallSnapshot notification result: {}, current snapshot index: {}", this.getMemberId(), RaftProtos.InstallSnapshotResult.ALREADY_INSTALLED, snapshotIndex);
                    RaftProtos.InstallSnapshotReplyProto reply2 = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, RaftProtos.InstallSnapshotResult.ALREADY_INSTALLED, snapshotIndex);
                    return future.thenApply(dummy -> reply2);
                }
                RaftProtos.RaftPeerProto leaderProto = !request.hasLastRaftConfigurationLogEntryProto() ? null : request.getLastRaftConfigurationLogEntryProto().getConfigurationEntry().getPeersList().stream().filter(p -> RaftPeerId.valueOf(p.getId()).equals(leaderId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Leader " + leaderId + " not found from the last configuration LogEntryProto, request = " + request));
                RaftProtos.RoleInfoProto proto = leaderProto == null || this.server.getRaftConf().getPeer(this.state.getLeaderId(), new RaftProtos.RaftPeerRole[0]) != null ? this.server.getRoleInfoProto() : this.getRoleInfoProto(ProtoUtils.toRaftPeer(leaderProto));
                LOG.info("{}: notifyInstallSnapshot: nextIndex is {} but the leader's first available index is {}.", this.getMemberId(), this.state.getLog().getNextIndex(), firstAvailableLogIndex);
                this.server.getStateMachine().followerEvent().notifyInstallSnapshotFromLeader(proto, firstAvailableLogTermIndex).whenComplete((reply, exception) -> {
                    if (exception != null) {
                        LOG.error("{}: Failed to notify StateMachine to InstallSnapshot. Exception: {}", (Object)this.getMemberId(), (Object)exception.getMessage());
                        this.inProgressInstallSnapshotIndex.compareAndSet(firstAvailableLogIndex, -1L);
                        return;
                    }
                    if (reply != null) {
                        LOG.info("{}: StateMachine successfully installed snapshot index {}. Reloading the StateMachine.", (Object)this.getMemberId(), (Object)reply.getIndex());
                        this.installedSnapshotTermIndex.set((TermIndex)reply);
                    } else {
                        this.isSnapshotNull.set(true);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{}: StateMachine could not install snapshot as it is not available", (Object)this);
                        }
                    }
                });
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: StateMachine is processing Snapshot Installation Request.", (Object)this.getMemberId());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{}: StateMachine is already installing a snapshot.", (Object)this.getMemberId());
            }
            long inProgressInstallSnapshotIndexValue = this.getInProgressInstallSnapshotIndex();
            Preconditions.assertTrue(inProgressInstallSnapshotIndexValue <= firstAvailableLogIndex && inProgressInstallSnapshotIndexValue > -1L, "inProgressInstallSnapshotRequest: %s is not eligible, firstAvailableLogIndex: %s", this.getInProgressInstallSnapshotIndex(), firstAvailableLogIndex);
            if (this.isSnapshotNull.compareAndSet(true, false)) {
                LOG.info("{}: InstallSnapshot notification result: {}", (Object)this.getMemberId(), (Object)RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE);
                this.inProgressInstallSnapshotIndex.set(-1L);
                this.server.getStateMachine().event().notifySnapshotInstalled(RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE, -1L, this.server.getPeer());
                RaftProtos.InstallSnapshotReplyProto reply3 = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE);
                return future.thenApply(dummy -> reply3);
            }
            TermIndex latestInstalledSnapshotTermIndex = this.installedSnapshotTermIndex.getAndSet(INVALID_TERM_INDEX);
            if (latestInstalledSnapshotTermIndex.getIndex() > -1L) {
                this.server.getStateMachine().pause();
                this.state.reloadStateMachine(latestInstalledSnapshotTermIndex);
                LOG.info("{}: InstallSnapshot notification result: {}, at index: {}", this.getMemberId(), RaftProtos.InstallSnapshotResult.SNAPSHOT_INSTALLED, latestInstalledSnapshotTermIndex);
                this.inProgressInstallSnapshotIndex.set(-1L);
                long latestInstalledIndex = latestInstalledSnapshotTermIndex.getIndex();
                this.server.getStateMachine().event().notifySnapshotInstalled(RaftProtos.InstallSnapshotResult.SNAPSHOT_INSTALLED, latestInstalledIndex, this.server.getPeer());
                this.installedIndex.set(latestInstalledIndex);
                RaftProtos.InstallSnapshotReplyProto reply4 = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, RaftProtos.InstallSnapshotResult.SNAPSHOT_INSTALLED, latestInstalledSnapshotTermIndex.getIndex());
                return future.thenApply(dummy -> reply4);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: InstallSnapshot notification result: {}", (Object)this.getMemberId(), (Object)RaftProtos.InstallSnapshotResult.IN_PROGRESS);
            }
            RaftProtos.InstallSnapshotReplyProto reply5 = ServerProtoUtils.toInstallSnapshotReplyProto(leaderId, this.getMemberId(), currentTerm, RaftProtos.InstallSnapshotResult.IN_PROGRESS);
            return future.thenApply(dummy -> reply5);
        }
    }

    private RaftProtos.RoleInfoProto getRoleInfoProto(RaftPeer leader) {
        RoleInfo role = this.server.getRole();
        Optional<FollowerState> fs = role.getFollowerState();
        RaftProtos.ServerRpcProto leaderInfo = ServerProtoUtils.toServerRpcProto(leader, fs.map(FollowerState::getLastRpcTime).map(Timestamp::elapsedTimeMs).orElse(0L));
        RaftProtos.FollowerInfoProto.Builder followerInfo = RaftProtos.FollowerInfoProto.newBuilder().setLeaderInfo(leaderInfo).setOutstandingOp(fs.map(FollowerState::getOutstandingOp).orElse(0));
        return RaftProtos.RoleInfoProto.newBuilder().setSelf(this.server.getPeer().getRaftPeerProto()).setRole(role.getCurrentRole()).setRoleElapsedTimeMs(role.getRoleElapsedTimeMs()).setFollowerInfo(followerInfo).build();
    }
}

