/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.counter.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Scanner;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.common.Constants;
import org.apache.ratis.examples.counter.server.CounterStateMachine;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.TimeDuration;

public final class CounterServer
implements Closeable {
    private final RaftServer server;

    public CounterServer(RaftPeer peer, File storageDir, TimeDuration simulatedSlowness) throws IOException {
        RaftProperties properties = new RaftProperties();
        RaftServerConfigKeys.setStorageDir(properties, Collections.singletonList(storageDir));
        RaftServerConfigKeys.Read.setOption(properties, RaftServerConfigKeys.Read.Option.LINEARIZABLE);
        RaftServerConfigKeys.Read.setTimeout(properties, TimeDuration.ONE_MINUTE);
        int port = NetUtils.createSocketAddr(peer.getAddress()).getPort();
        GrpcConfigKeys.Server.setPort(properties, port);
        CounterStateMachine counterStateMachine = new CounterStateMachine(simulatedSlowness);
        this.server = RaftServer.newBuilder().setGroup(Constants.RAFT_GROUP).setProperties(properties).setServerId(peer.getId()).setStateMachine(counterStateMachine).setOption(RaftStorage.StartupOption.RECOVER).build();
    }

    public void start() throws IOException {
        this.server.start();
    }

    @Override
    public void close() throws IOException {
        this.server.close();
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new IllegalArgumentException("Invalid argument number: expected to be 1 but actual is " + args.length);
            }
            int peerIndex = Integer.parseInt(args[0]);
            if (peerIndex < 0 || peerIndex > 2) {
                throw new IllegalArgumentException("The server index must be 0, 1 or 2: peerIndex=" + peerIndex);
            }
            TimeDuration simulatedSlowness = Optional.ofNullable(Constants.SIMULATED_SLOWNESS).map(slownessList -> (TimeDuration)slownessList.get(peerIndex)).orElse(TimeDuration.ZERO);
            CounterServer.startServer(peerIndex, simulatedSlowness);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println();
            System.err.println("args = " + Arrays.toString(args));
            System.err.println();
            System.err.println("Usage: java org.apache.ratis.examples.counter.server.CounterServer peer_index");
            System.err.println();
            System.err.println("       peer_index must be 0, 1 or 2");
            System.exit(1);
        }
    }

    private static void startServer(int peerIndex, TimeDuration simulatedSlowness) throws IOException {
        RaftPeer currentPeer = Constants.PEERS.get(peerIndex);
        File storageDir = new File("./" + currentPeer.getId());
        try (CounterServer counterServer = new CounterServer(currentPeer, storageDir, simulatedSlowness);){
            counterServer.start();
            new Scanner(System.in, StandardCharsets.UTF_8.name()).nextLine();
        }
    }
}

