/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;

public interface ReferenceCountedObject<T> {
    public T get();

    public T retain();

    default public UncheckedAutoCloseableSupplier<T> retainAndReleaseOnClose() {
        final T retained = this.retain();
        final AtomicBoolean closed = new AtomicBoolean();
        return new UncheckedAutoCloseableSupplier<T>(){

            @Override
            public T get() {
                if (closed.get()) {
                    throw new IllegalStateException("Already closed");
                }
                return retained;
            }

            @Override
            public void close() {
                if (closed.compareAndSet(false, true)) {
                    ReferenceCountedObject.this.release();
                }
            }
        };
    }

    public boolean release();

    public static <V> ReferenceCountedObject<V> wrap(V value) {
        return ReferenceCountedObject.wrap(value, () -> {}, (Boolean ignored) -> {});
    }

    public static <V> ReferenceCountedObject<V> wrap(final V value, final Runnable retainMethod, final Consumer<Boolean> releaseMethod) {
        Objects.requireNonNull(value, "value == null");
        Objects.requireNonNull(retainMethod, "retainMethod == null");
        Objects.requireNonNull(releaseMethod, "releaseMethod == null");
        return new ReferenceCountedObject<V>(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public V get() {
                int previous = this.count.get();
                if (previous < 0) {
                    throw new IllegalStateException("Failed to get: object has already been completely released.");
                }
                if (previous == 0) {
                    throw new IllegalStateException("Failed to get: object has not yet been retained.");
                }
                return value;
            }

            @Override
            public V retain() {
                if (this.count.getAndUpdate(n -> n < 0 ? n : n + 1) < 0) {
                    throw new IllegalStateException("Failed to retain: object has already been completely released.");
                }
                retainMethod.run();
                return value;
            }

            @Override
            public boolean release() {
                int previous = this.count.getAndUpdate(n -> n <= 1 ? -1 : n - 1);
                if (previous < 0) {
                    throw new IllegalStateException("Failed to release: object has already been completely released.");
                }
                if (previous == 0) {
                    throw new IllegalStateException("Failed to release: object has not yet been retained.");
                }
                boolean completedReleased = previous == 1;
                releaseMethod.accept(completedReleased);
                return completedReleased;
            }
        };
    }

    public static <V> ReferenceCountedObject<V> wrap(V value, Runnable retainMethod, Runnable releaseMethod) {
        return ReferenceCountedObject.wrap(value, retainMethod, (Boolean ignored) -> releaseMethod.run());
    }
}

