/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.kv;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.kv.CompactionLog;
import org.apache.rocketmq.store.kv.CompactionPositionMgr;

public class CompactionStore {
    public static final String COMPACTION_DIR = "compaction";
    public static final String COMPACTION_LOG_DIR = "compactionLog";
    public static final String COMPACTION_CQ_DIR = "compactionCq";
    private final String compactionPath;
    private final String compactionLogPath;
    private final String compactionCqPath;
    private final MessageStore defaultMessageStore;
    private final CompactionPositionMgr positionMgr;
    private final ConcurrentHashMap<String, CompactionLog> compactionLogTable;
    private final ScheduledExecutorService compactionSchedule;
    private final int compactionInterval;
    private final int compactionThreadNum;
    private final int offsetMapSize;
    private String masterAddr;
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");

    public CompactionStore(MessageStore defaultMessageStore) {
        this.defaultMessageStore = defaultMessageStore;
        this.compactionLogTable = new ConcurrentHashMap();
        MessageStoreConfig config = defaultMessageStore.getMessageStoreConfig();
        String storeRootPath = config.getStorePathRootDir();
        this.compactionPath = Paths.get(storeRootPath, COMPACTION_DIR).toString();
        this.compactionLogPath = Paths.get(this.compactionPath, COMPACTION_LOG_DIR).toString();
        this.compactionCqPath = Paths.get(this.compactionPath, COMPACTION_CQ_DIR).toString();
        this.positionMgr = new CompactionPositionMgr(this.compactionPath);
        this.compactionThreadNum = config.getCompactionThreadNum() <= 0 ? Runtime.getRuntime().availableProcessors() : config.getCompactionThreadNum();
        this.compactionSchedule = Executors.newScheduledThreadPool(this.compactionThreadNum, (ThreadFactory)new ThreadFactoryImpl("compactionSchedule_"));
        this.offsetMapSize = config.getMaxOffsetMapSize() / this.compactionThreadNum;
        this.compactionInterval = defaultMessageStore.getMessageStoreConfig().getCompactionScheduleInternal();
    }

    public void load(boolean exitOk) throws Exception {
        File logRoot = new File(this.compactionLogPath);
        File[] fileTopicList = logRoot.listFiles();
        if (fileTopicList != null) {
            for (File fileTopic : fileTopicList) {
                File[] fileQueueIdList;
                if (!fileTopic.isDirectory() || (fileQueueIdList = fileTopic.listFiles()) == null) continue;
                for (File fileQueueId : fileQueueIdList) {
                    if (!fileQueueId.isDirectory()) continue;
                    try {
                        String topic = fileTopic.getName();
                        int queueId = Integer.parseInt(fileQueueId.getName());
                        if (Files.isDirectory(Paths.get(this.compactionCqPath, topic, String.valueOf(queueId)), new LinkOption[0])) {
                            CompactionLog log = new CompactionLog(this.defaultMessageStore, this, topic, queueId);
                            log.load(exitOk);
                            this.compactionLogTable.put(topic + "_" + queueId, log);
                            this.compactionSchedule.scheduleWithFixedDelay(log::doCompaction, this.compactionInterval, this.compactionInterval, TimeUnit.MILLISECONDS);
                            continue;
                        }
                        log.error("{}:{} compactionLog mismatch with compactionCq", (Object)topic, (Object)queueId);
                    }
                    catch (Exception e) {
                        log.error("load compactionLog {}:{} exception: ", new Object[]{fileTopic.getName(), fileQueueId.getName(), e});
                        throw new Exception("load compactionLog " + fileTopic.getName() + ":" + fileQueueId.getName() + " exception: " + e.getMessage());
                    }
                }
            }
        }
        log.info("compactionStore {}:{} load completed.", (Object)this.compactionLogPath, (Object)this.compactionCqPath);
    }

    public void putMessage(String topic, int queueId, SelectMappedBufferResult smr) throws Exception {
        CompactionLog clog = this.compactionLogTable.compute(topic + "_" + queueId, (k, v) -> {
            if (v == null) {
                try {
                    v = new CompactionLog(this.defaultMessageStore, this, topic, queueId);
                    v.load(true);
                    this.compactionSchedule.scheduleWithFixedDelay(v::doCompaction, this.compactionInterval, this.compactionInterval, TimeUnit.MILLISECONDS);
                }
                catch (IOException e) {
                    log.error("create compactionLog exception: ", (Throwable)e);
                    return null;
                }
            }
            return v;
        });
        if (clog != null) {
            clog.asyncPutMessage(smr);
        }
    }

    public GetMessageResult getMessage(String group, String topic, int queueId, long offset, int maxMsgNums, int maxTotalMsgSize) {
        CompactionLog log = this.compactionLogTable.get(topic + "_" + queueId);
        if (log == null) {
            return GetMessageResult.NO_MATCH_LOGIC_QUEUE;
        }
        return log.getMessage(group, topic, queueId, offset, maxMsgNums, maxTotalMsgSize);
    }

    public void flushCQ(int flushLeastPages) {
        this.compactionLogTable.values().forEach(log -> log.flushCQ(flushLeastPages));
    }

    public void updateMasterAddress(String addr) {
        this.masterAddr = addr;
    }

    public void shutdown() {
        this.positionMgr.persist();
        this.compactionSchedule.shutdown();
        try {
            if (!this.compactionSchedule.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                List<Runnable> droppedTasks = this.compactionSchedule.shutdownNow();
                log.warn("compactionSchedule was abruptly shutdown. {} tasks will not be executed.", (Object)droppedTasks.size());
            }
        }
        catch (InterruptedException e) {
            log.warn("wait compaction schedule shutdown interrupted. ");
        }
    }

    public ScheduledExecutorService getCompactionSchedule() {
        return this.compactionSchedule;
    }

    public String getCompactionLogPath() {
        return this.compactionLogPath;
    }

    public String getCompactionCqPath() {
        return this.compactionCqPath;
    }

    public CompactionPositionMgr getPositionMgr() {
        return this.positionMgr;
    }

    public int getOffsetMapSize() {
        return this.offsetMapSize;
    }

    public String getMasterAddr() {
        return this.masterAddr;
    }
}

