/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filter.expression;

import java.util.List;
import org.apache.rocketmq.filter.expression.BinaryExpression;
import org.apache.rocketmq.filter.expression.BooleanConstantExpression;
import org.apache.rocketmq.filter.expression.BooleanExpression;
import org.apache.rocketmq.filter.expression.ConstantExpression;
import org.apache.rocketmq.filter.expression.EvaluationContext;
import org.apache.rocketmq.filter.expression.Expression;
import org.apache.rocketmq.filter.expression.LogicExpression;
import org.apache.rocketmq.filter.expression.PropertyExpression;
import org.apache.rocketmq.filter.expression.UnaryExpression;

public abstract class ComparisonExpression
extends BinaryExpression
implements BooleanExpression {
    public static final ThreadLocal<Boolean> CONVERT_STRING_EXPRESSIONS = new ThreadLocal();
    boolean convertStringExpressions = CONVERT_STRING_EXPRESSIONS.get() != null;

    public ComparisonExpression(Expression left, Expression right) {
        super(left, right);
    }

    public static BooleanExpression createBetween(Expression value, Expression left, Expression right) {
        if (left instanceof ConstantExpression && right instanceof ConstantExpression) {
            int ret;
            Object lv = ((ConstantExpression)left).getValue();
            Object rv = ((ConstantExpression)right).getValue();
            if (lv == null || rv == null) {
                throw new RuntimeException("Illegal values of between, values can not be null!");
            }
            if (lv instanceof Comparable && rv instanceof Comparable && (ret = ComparisonExpression.__compare((Comparable)rv, (Comparable)lv, true)) < 0) {
                throw new RuntimeException(String.format("Illegal values of between, left value(%s) must less than or equal to right value(%s)", lv, rv));
            }
        }
        return LogicExpression.createAND(ComparisonExpression.createGreaterThanEqual(value, left), ComparisonExpression.createLessThanEqual(value, right));
    }

    public static BooleanExpression createNotBetween(Expression value, Expression left, Expression right) {
        return LogicExpression.createOR(ComparisonExpression.createLessThan(value, left), ComparisonExpression.createGreaterThan(value, right));
    }

    public static BooleanExpression createContains(Expression left, String search) {
        return new ContainsExpression(left, search);
    }

    public static BooleanExpression createNotContains(Expression left, String search) {
        return new NotContainsExpression(left, search);
    }

    public static BooleanExpression createStartsWith(Expression left, String search) {
        return new StartsWithExpression(left, search);
    }

    public static BooleanExpression createNotStartsWith(Expression left, String search) {
        return new NotStartsWithExpression(left, search);
    }

    public static BooleanExpression createEndsWith(Expression left, String search) {
        return new EndsWithExpression(left, search);
    }

    public static BooleanExpression createNotEndsWith(Expression left, String search) {
        return new NotEndsWithExpression(left, search);
    }

    public static BooleanExpression createInFilter(Expression left, List elements) {
        if (!(left instanceof PropertyExpression)) {
            throw new RuntimeException("Expected a property for In expression, got: " + left);
        }
        return UnaryExpression.createInExpression((PropertyExpression)left, elements, false);
    }

    public static BooleanExpression createNotInFilter(Expression left, List elements) {
        if (!(left instanceof PropertyExpression)) {
            throw new RuntimeException("Expected a property for In expression, got: " + left);
        }
        return UnaryExpression.createInExpression((PropertyExpression)left, elements, true);
    }

    public static BooleanExpression createIsNull(Expression left) {
        return ComparisonExpression.doCreateEqual(left, BooleanConstantExpression.NULL);
    }

    public static BooleanExpression createIsNotNull(Expression left) {
        return UnaryExpression.createNOT(ComparisonExpression.doCreateEqual(left, BooleanConstantExpression.NULL));
    }

    public static BooleanExpression createNotEqual(Expression left, Expression right) {
        return UnaryExpression.createNOT(ComparisonExpression.createEqual(left, right));
    }

    public static BooleanExpression createEqual(Expression left, Expression right) {
        ComparisonExpression.checkEqualOperand(left);
        ComparisonExpression.checkEqualOperand(right);
        ComparisonExpression.checkEqualOperandCompatability(left, right);
        return ComparisonExpression.doCreateEqual(left, right);
    }

    private static BooleanExpression doCreateEqual(Expression left, Expression right) {
        return new ComparisonExpression(left, right){

            @Override
            public Object evaluate(EvaluationContext context) throws Exception {
                Object rv;
                Object lv = this.left.evaluate(context);
                if (lv == null ^ (rv = this.right.evaluate(context)) == null) {
                    if (lv == null) {
                        return null;
                    }
                    return Boolean.FALSE;
                }
                if (lv == rv || lv.equals(rv)) {
                    return Boolean.TRUE;
                }
                if (lv instanceof Comparable && rv instanceof Comparable) {
                    return this.compare((Comparable)lv, (Comparable)rv);
                }
                return Boolean.FALSE;
            }

            @Override
            protected boolean asBoolean(int answer) {
                return answer == 0;
            }

            @Override
            public String getExpressionSymbol() {
                return "==";
            }
        };
    }

    public static BooleanExpression createGreaterThan(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            @Override
            protected boolean asBoolean(int answer) {
                return answer > 0;
            }

            @Override
            public String getExpressionSymbol() {
                return ">";
            }
        };
    }

    public static BooleanExpression createGreaterThanEqual(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            @Override
            protected boolean asBoolean(int answer) {
                return answer >= 0;
            }

            @Override
            public String getExpressionSymbol() {
                return ">=";
            }
        };
    }

    public static BooleanExpression createLessThan(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            @Override
            protected boolean asBoolean(int answer) {
                return answer < 0;
            }

            @Override
            public String getExpressionSymbol() {
                return "<";
            }
        };
    }

    public static BooleanExpression createLessThanEqual(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            @Override
            protected boolean asBoolean(int answer) {
                return answer <= 0;
            }

            @Override
            public String getExpressionSymbol() {
                return "<=";
            }
        };
    }

    public static void checkLessThanOperand(Expression expr) {
        if (expr instanceof ConstantExpression) {
            Object value = ((ConstantExpression)expr).getValue();
            if (value instanceof Number) {
                return;
            }
            throw new RuntimeException("Value '" + expr + "' cannot be compared.");
        }
        if (expr instanceof BooleanExpression) {
            throw new RuntimeException("Value '" + expr + "' cannot be compared.");
        }
    }

    public static void checkEqualOperand(Expression expr) {
        Object value;
        if (expr instanceof ConstantExpression && (value = ((ConstantExpression)expr).getValue()) == null) {
            throw new RuntimeException("'" + expr + "' cannot be compared.");
        }
    }

    private static void checkEqualOperandCompatability(Expression left, Expression right) {
        if (left instanceof ConstantExpression && right instanceof ConstantExpression && left instanceof BooleanExpression && !(right instanceof BooleanExpression)) {
            throw new RuntimeException("'" + left + "' cannot be compared with '" + right + "'");
        }
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        Class<?> rc;
        Class<?> lc;
        Comparable lv = (Comparable)this.left.evaluate(context);
        if (lv == null) {
            return null;
        }
        Comparable rv = (Comparable)this.right.evaluate(context);
        if (rv == null) {
            return null;
        }
        if ((this.getExpressionSymbol().equals(">=") || this.getExpressionSymbol().equals(">") || this.getExpressionSymbol().equals("<") || this.getExpressionSymbol().equals("<=")) && (lc = lv.getClass()) == (rc = rv.getClass()) && lc == String.class) {
            try {
                Double lvC = Double.valueOf((String)((Object)lv));
                Double rvC = Double.valueOf((String)((Object)rv));
                return this.compare(lvC, rvC);
            }
            catch (Exception e) {
                throw new RuntimeException("It's illegal to compare string by '>=', '>', '<', '<='. lv=" + lv + ", rv=" + rv, e);
            }
        }
        return this.compare(lv, rv);
    }

    protected static int __compare(Comparable lv, Comparable rv, boolean convertStringExpressions) {
        block46: {
            Class<?> rc;
            Class<?> lc = lv.getClass();
            if (lc != (rc = rv.getClass())) {
                try {
                    if (lc == Boolean.class) {
                        if (convertStringExpressions && rc == String.class) {
                            lv = Boolean.valueOf((String)((Object)lv));
                            break block46;
                        }
                        return -1;
                    }
                    if (lc == Byte.class) {
                        if (rc == Short.class) {
                            lv = Short.valueOf(((Number)((Object)lv)).shortValue());
                            break block46;
                        }
                        if (rc == Integer.class) {
                            lv = Integer.valueOf(((Number)((Object)lv)).intValue());
                            break block46;
                        }
                        if (rc == Long.class) {
                            lv = Long.valueOf(((Number)((Object)lv)).longValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = new Float(((Number)((Object)lv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = new Double(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (convertStringExpressions && rc == String.class) {
                            rv = Byte.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return -1;
                    }
                    if (lc == Short.class) {
                        if (rc == Integer.class) {
                            lv = Integer.valueOf(((Number)((Object)lv)).intValue());
                            break block46;
                        }
                        if (rc == Long.class) {
                            lv = Long.valueOf(((Number)((Object)lv)).longValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = new Float(((Number)((Object)lv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = new Double(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (convertStringExpressions && rc == String.class) {
                            rv = Short.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return -1;
                    }
                    if (lc == Integer.class) {
                        if (rc == Long.class) {
                            lv = Long.valueOf(((Number)((Object)lv)).longValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = new Float(((Number)((Object)lv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = new Double(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (convertStringExpressions && rc == String.class) {
                            rv = Integer.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return -1;
                    }
                    if (lc == Long.class) {
                        if (rc == Integer.class) {
                            rv = Long.valueOf(((Number)((Object)rv)).longValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = new Float(((Number)((Object)lv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = new Double(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (convertStringExpressions && rc == String.class) {
                            rv = Long.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return -1;
                    }
                    if (lc == Float.class) {
                        if (rc == Integer.class) {
                            rv = new Float(((Number)((Object)rv)).floatValue());
                            break block46;
                        }
                        if (rc == Long.class) {
                            rv = new Float(((Number)((Object)rv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = new Double(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (convertStringExpressions && rc == String.class) {
                            rv = Float.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return -1;
                    }
                    if (lc == Double.class) {
                        if (rc == Integer.class) {
                            rv = new Double(((Number)((Object)rv)).doubleValue());
                            break block46;
                        }
                        if (rc == Long.class) {
                            rv = new Double(((Number)((Object)rv)).doubleValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            rv = new Float(((Number)((Object)rv)).doubleValue());
                            break block46;
                        }
                        if (convertStringExpressions && rc == String.class) {
                            rv = Double.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return -1;
                    }
                    if (convertStringExpressions && lc == String.class) {
                        if (rc == Boolean.class) {
                            lv = Boolean.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Byte.class) {
                            lv = Byte.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Short.class) {
                            lv = Short.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Integer.class) {
                            lv = Integer.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Long.class) {
                            lv = Long.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = Float.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = Double.valueOf((String)((Object)lv));
                            break block46;
                        }
                        return -1;
                    }
                    return -1;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return lv.compareTo(rv);
    }

    protected Boolean compare(Comparable lv, Comparable rv) {
        return this.asBoolean(ComparisonExpression.__compare(lv, rv, this.convertStringExpressions)) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected abstract boolean asBoolean(int var1);

    @Override
    public boolean matches(EvaluationContext context) throws Exception {
        Object object = this.evaluate(context);
        return object != null && object == Boolean.TRUE;
    }

    static class NotEndsWithExpression
    extends UnaryExpression
    implements BooleanExpression {
        String search;

        public NotEndsWithExpression(Expression right, String search) {
            super(right);
            this.search = search;
        }

        @Override
        public String getExpressionSymbol() {
            return "NOT ENDSWITH";
        }

        @Override
        public Object evaluate(EvaluationContext message) throws Exception {
            if (this.search == null || this.search.length() == 0) {
                return Boolean.FALSE;
            }
            Object rv = this.getRight().evaluate(message);
            if (rv == null) {
                return Boolean.FALSE;
            }
            if (!(rv instanceof String)) {
                return Boolean.FALSE;
            }
            return ((String)rv).endsWith(this.search) ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public boolean matches(EvaluationContext message) throws Exception {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }

    static class EndsWithExpression
    extends UnaryExpression
    implements BooleanExpression {
        String search;

        public EndsWithExpression(Expression right, String search) {
            super(right);
            this.search = search;
        }

        @Override
        public String getExpressionSymbol() {
            return "ENDSWITH";
        }

        @Override
        public Object evaluate(EvaluationContext message) throws Exception {
            if (this.search == null || this.search.length() == 0) {
                return Boolean.FALSE;
            }
            Object rv = this.getRight().evaluate(message);
            if (rv == null) {
                return Boolean.FALSE;
            }
            if (!(rv instanceof String)) {
                return Boolean.FALSE;
            }
            return ((String)rv).endsWith(this.search) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean matches(EvaluationContext message) throws Exception {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }

    static class NotStartsWithExpression
    extends UnaryExpression
    implements BooleanExpression {
        String search;

        public NotStartsWithExpression(Expression right, String search) {
            super(right);
            this.search = search;
        }

        @Override
        public String getExpressionSymbol() {
            return "NOT STARTSWITH";
        }

        @Override
        public Object evaluate(EvaluationContext message) throws Exception {
            if (this.search == null || this.search.length() == 0) {
                return Boolean.FALSE;
            }
            Object rv = this.getRight().evaluate(message);
            if (rv == null) {
                return Boolean.FALSE;
            }
            if (!(rv instanceof String)) {
                return Boolean.FALSE;
            }
            return ((String)rv).startsWith(this.search) ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public boolean matches(EvaluationContext message) throws Exception {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }

    static class StartsWithExpression
    extends UnaryExpression
    implements BooleanExpression {
        String search;

        public StartsWithExpression(Expression right, String search) {
            super(right);
            this.search = search;
        }

        @Override
        public String getExpressionSymbol() {
            return "STARTSWITH";
        }

        @Override
        public Object evaluate(EvaluationContext message) throws Exception {
            if (this.search == null || this.search.length() == 0) {
                return Boolean.FALSE;
            }
            Object rv = this.getRight().evaluate(message);
            if (rv == null) {
                return Boolean.FALSE;
            }
            if (!(rv instanceof String)) {
                return Boolean.FALSE;
            }
            return ((String)rv).startsWith(this.search) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean matches(EvaluationContext message) throws Exception {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }

    static class NotContainsExpression
    extends UnaryExpression
    implements BooleanExpression {
        String search;

        public NotContainsExpression(Expression right, String search) {
            super(right);
            this.search = search;
        }

        @Override
        public String getExpressionSymbol() {
            return "NOT CONTAINS";
        }

        @Override
        public Object evaluate(EvaluationContext message) throws Exception {
            if (this.search == null || this.search.length() == 0) {
                return Boolean.FALSE;
            }
            Object rv = this.getRight().evaluate(message);
            if (rv == null) {
                return Boolean.FALSE;
            }
            if (!(rv instanceof String)) {
                return Boolean.FALSE;
            }
            return ((String)rv).contains(this.search) ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public boolean matches(EvaluationContext message) throws Exception {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }

    static class ContainsExpression
    extends UnaryExpression
    implements BooleanExpression {
        String search;

        public ContainsExpression(Expression right, String search) {
            super(right);
            this.search = search;
        }

        @Override
        public String getExpressionSymbol() {
            return "CONTAINS";
        }

        @Override
        public Object evaluate(EvaluationContext message) throws Exception {
            if (this.search == null || this.search.length() == 0) {
                return Boolean.FALSE;
            }
            Object rv = this.getRight().evaluate(message);
            if (rv == null) {
                return Boolean.FALSE;
            }
            if (!(rv instanceof String)) {
                return Boolean.FALSE;
            }
            return ((String)rv).contains(this.search) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean matches(EvaluationContext message) throws Exception {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }
}

