/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.timer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.timer.Slot;

public class TimerWheel {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    public static final int BLANK = -1;
    public static final int IGNORE = -2;
    public final int slotsTotal;
    public final int precisionMs;
    private String fileName;
    private final RandomAccessFile randomAccessFile;
    private final FileChannel fileChannel;
    private final MappedByteBuffer mappedByteBuffer;
    private final ByteBuffer byteBuffer;
    private final ThreadLocal<ByteBuffer> localBuffer = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return TimerWheel.this.byteBuffer.duplicate();
        }
    };
    private final int wheelLength;

    public TimerWheel(String fileName, int slotsTotal, int precisionMs) throws IOException {
        this.slotsTotal = slotsTotal;
        this.precisionMs = precisionMs;
        this.fileName = fileName;
        this.wheelLength = this.slotsTotal * 2 * 32;
        File file = new File(fileName);
        UtilAll.ensureDirOK((String)file.getParent());
        try {
            this.randomAccessFile = new RandomAccessFile(this.fileName, "rw");
            if (file.exists() && this.randomAccessFile.length() != 0L && this.randomAccessFile.length() != (long)this.wheelLength) {
                throw new RuntimeException(String.format("Timer wheel length:%d != expected:%s", this.randomAccessFile.length(), this.wheelLength));
            }
            this.randomAccessFile.setLength(this.wheelLength);
            this.fileChannel = this.randomAccessFile.getChannel();
            this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.wheelLength);
            assert (this.wheelLength == this.mappedByteBuffer.remaining());
            this.byteBuffer = ByteBuffer.allocateDirect(this.wheelLength);
            this.byteBuffer.put(this.mappedByteBuffer);
        }
        catch (FileNotFoundException e) {
            log.error("create file channel " + this.fileName + " Failed. ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error("map file " + this.fileName + " Failed. ", (Throwable)e);
            throw e;
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean flush) {
        if (flush) {
            this.flush();
        }
        UtilAll.cleanBuffer((ByteBuffer)this.mappedByteBuffer);
        UtilAll.cleanBuffer((ByteBuffer)this.byteBuffer);
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            log.error("Shutdown error in timer wheel", (Throwable)e);
        }
    }

    public void flush() {
        ByteBuffer bf = this.localBuffer.get();
        bf.position(0);
        bf.limit(this.wheelLength);
        this.mappedByteBuffer.position(0);
        this.mappedByteBuffer.limit(this.wheelLength);
        for (int i = 0; i < this.wheelLength; ++i) {
            if (bf.get(i) == this.mappedByteBuffer.get(i)) continue;
            this.mappedByteBuffer.put(i, bf.get(i));
        }
        this.mappedByteBuffer.force();
    }

    public Slot getSlot(long timeMs) {
        Slot slot = this.getRawSlot(timeMs);
        if (slot.timeMs != timeMs / (long)this.precisionMs * (long)this.precisionMs) {
            return new Slot(-1L, -1L, -1L);
        }
        return slot;
    }

    public Slot getRawSlot(long timeMs) {
        this.localBuffer.get().position(this.getSlotIndex(timeMs) * 32);
        return new Slot(this.localBuffer.get().getLong() * (long)this.precisionMs, this.localBuffer.get().getLong(), this.localBuffer.get().getLong(), this.localBuffer.get().getInt(), this.localBuffer.get().getInt());
    }

    public int getSlotIndex(long timeMs) {
        return (int)(timeMs / (long)this.precisionMs % (long)(this.slotsTotal * 2));
    }

    public void putSlot(long timeMs, long firstPos, long lastPos) {
        this.localBuffer.get().position(this.getSlotIndex(timeMs) * 32);
        this.localBuffer.get().putLong(timeMs / (long)this.precisionMs);
        this.localBuffer.get().putLong(firstPos);
        this.localBuffer.get().putLong(lastPos);
    }

    public void putSlot(long timeMs, long firstPos, long lastPos, int num, int magic) {
        this.localBuffer.get().position(this.getSlotIndex(timeMs) * 32);
        this.localBuffer.get().putLong(timeMs / (long)this.precisionMs);
        this.localBuffer.get().putLong(firstPos);
        this.localBuffer.get().putLong(lastPos);
        this.localBuffer.get().putInt(num);
        this.localBuffer.get().putInt(magic);
    }

    public void reviseSlot(long timeMs, long firstPos, long lastPos, boolean force) {
        this.localBuffer.get().position(this.getSlotIndex(timeMs) * 32);
        if (timeMs / (long)this.precisionMs != this.localBuffer.get().getLong()) {
            if (force) {
                this.putSlot(timeMs, firstPos != -2L ? firstPos : lastPos, lastPos);
            }
        } else {
            if (-2L != firstPos) {
                this.localBuffer.get().putLong(firstPos);
            } else {
                this.localBuffer.get().getLong();
            }
            if (-2L != lastPos) {
                this.localBuffer.get().putLong(lastPos);
            }
        }
    }

    public long checkPhyPos(long timeStartMs, long maxOffset) {
        long minFirst = Long.MAX_VALUE;
        int firstSlotIndex = this.getSlotIndex(timeStartMs);
        for (int i = 0; i < this.slotsTotal * 2; ++i) {
            int slotIndex = (firstSlotIndex + i) % (this.slotsTotal * 2);
            this.localBuffer.get().position(slotIndex * 32);
            if ((timeStartMs + (long)(i * this.precisionMs)) / (long)this.precisionMs != this.localBuffer.get().getLong()) continue;
            long first = this.localBuffer.get().getLong();
            long last = this.localBuffer.get().getLong();
            if (last <= maxOffset || first >= minFirst) continue;
            minFirst = first;
        }
        return minFirst;
    }

    public long getNum(long timeMs) {
        return this.getSlot((long)timeMs).num;
    }

    public long getAllNum(long timeStartMs) {
        int allNum = 0;
        int firstSlotIndex = this.getSlotIndex(timeStartMs);
        for (int i = 0; i < this.slotsTotal * 2; ++i) {
            int slotIndex = (firstSlotIndex + i) % (this.slotsTotal * 2);
            this.localBuffer.get().position(slotIndex * 32);
            if ((timeStartMs + (long)(i * this.precisionMs)) / (long)this.precisionMs != this.localBuffer.get().getLong()) continue;
            this.localBuffer.get().getLong();
            this.localBuffer.get().getLong();
            allNum += this.localBuffer.get().getInt();
        }
        return allNum;
    }
}

