/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.consumer;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.admin.ConsumeStats;
import org.apache.rocketmq.remoting.protocol.admin.OffsetWrapper;
import org.apache.rocketmq.remoting.protocol.body.Connection;
import org.apache.rocketmq.remoting.protocol.body.ConsumerConnection;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.remoting.protocol.body.TopicList;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;
import org.apache.rocketmq.tools.command.consumer.GroupConsumeInfo;

public class ConsumerProgressSubCommand
implements SubCommand {
    private static final Logger log = LoggerFactory.getLogger(ConsumerProgressSubCommand.class);

    @Override
    public String commandName() {
        return "consumerProgress";
    }

    @Override
    public String commandDesc() {
        return "Query consumer's progress, speed.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("g", "groupName", true, "consumer group name");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topicName", true, "topic name");
        opt.setRequired(false);
        options.addOption(opt);
        Option optionShowClientIP = new Option("s", "showClientIP", true, "Show Client IP per Queue");
        optionShowClientIP.setRequired(false);
        options.addOption(optionShowClientIP);
        return options;
    }

    private Map<MessageQueue, String> getMessageQueueAllocationResult(DefaultMQAdminExt defaultMQAdminExt, String groupName) {
        HashMap<MessageQueue, String> results = new HashMap<MessageQueue, String>();
        try {
            ConsumerConnection consumerConnection = defaultMQAdminExt.examineConsumerConnectionInfo(groupName);
            for (Connection connection : consumerConnection.getConnectionSet()) {
                String clientId = connection.getClientId();
                ConsumerRunningInfo consumerRunningInfo = defaultMQAdminExt.getConsumerRunningInfo(groupName, clientId, false, false);
                for (MessageQueue messageQueue : consumerRunningInfo.getMqTable().keySet()) {
                    results.put(messageQueue, clientId.split("@")[0]);
                }
            }
        }
        catch (Exception e) {
            log.error("getMqAllocationsResult error, ", (Throwable)e);
        }
        return results;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        block24: {
            DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
            defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
            if (commandLine.hasOption('n')) {
                defaultMQAdminExt.setNamesrvAddr(commandLine.getOptionValue('n').trim());
            }
            try {
                boolean showClientIP;
                defaultMQAdminExt.start();
                boolean bl = showClientIP = commandLine.hasOption('s') && "true".equalsIgnoreCase(commandLine.getOptionValue('s'));
                if (commandLine.hasOption('g')) {
                    String consumerGroup = commandLine.getOptionValue('g').trim();
                    String topicName = commandLine.hasOption('t') ? commandLine.getOptionValue('t').trim() : null;
                    ConsumeStats consumeStats = topicName == null ? defaultMQAdminExt.examineConsumeStats(consumerGroup) : defaultMQAdminExt.examineConsumeStats(consumerGroup, topicName);
                    LinkedList mqList = new LinkedList(consumeStats.getOffsetTable().keySet());
                    Collections.sort(mqList);
                    Map<MessageQueue, String> messageQueueAllocationResult = null;
                    if (showClientIP) {
                        messageQueueAllocationResult = this.getMessageQueueAllocationResult(defaultMQAdminExt, consumerGroup);
                    }
                    if (showClientIP) {
                        System.out.printf("%-64s  %-32s  %-4s  %-20s  %-20s  %-20s %-20s %-20s%s%n", "#Topic", "#Broker Name", "#QID", "#Broker Offset", "#Consumer Offset", "#Client IP", "#Diff", "#Inflight", "#LastTime");
                    } else {
                        System.out.printf("%-64s  %-32s  %-4s  %-20s  %-20s  %-20s %-20s%s%n", "#Topic", "#Broker Name", "#QID", "#Broker Offset", "#Consumer Offset", "#Diff", "#Inflight", "#LastTime");
                    }
                    long diffTotal = 0L;
                    long inflightTotal = 0L;
                    for (MessageQueue mq : mqList) {
                        OffsetWrapper offsetWrapper = (OffsetWrapper)consumeStats.getOffsetTable().get(mq);
                        long diff = offsetWrapper.getBrokerOffset() - offsetWrapper.getConsumerOffset();
                        long inflight = offsetWrapper.getPullOffset() - offsetWrapper.getConsumerOffset();
                        diffTotal += diff;
                        inflightTotal += inflight;
                        String lastTime = "";
                        try {
                            lastTime = offsetWrapper.getLastTimestamp() == 0L ? "N/A" : UtilAll.formatDate((Date)new Date(offsetWrapper.getLastTimestamp()), (String)"yyyy-MM-dd HH:mm:ss");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String clientIP = null;
                        if (showClientIP) {
                            clientIP = messageQueueAllocationResult.get(mq);
                        }
                        if (showClientIP) {
                            System.out.printf("%-64s  %-32s  %-4d  %-20d  %-20d  %-20s %-20d %-20d %s%n", UtilAll.frontStringAtLeast((String)mq.getTopic(), (int)64), UtilAll.frontStringAtLeast((String)mq.getBrokerName(), (int)32), mq.getQueueId(), offsetWrapper.getBrokerOffset(), offsetWrapper.getConsumerOffset(), null != clientIP ? clientIP : "N/A", diff, inflight, lastTime);
                            continue;
                        }
                        System.out.printf("%-64s  %-32s  %-4d  %-20d  %-20d  %-20d %-20d %s%n", UtilAll.frontStringAtLeast((String)mq.getTopic(), (int)64), UtilAll.frontStringAtLeast((String)mq.getBrokerName(), (int)32), mq.getQueueId(), offsetWrapper.getBrokerOffset(), offsetWrapper.getConsumerOffset(), diff, inflight, lastTime);
                    }
                    System.out.printf("%n", new Object[0]);
                    System.out.printf("Consume TPS: %.2f%n", consumeStats.getConsumeTps());
                    System.out.printf("Consume Diff Total: %d%n", diffTotal);
                    System.out.printf("Consume Inflight Total: %d%n", inflightTotal);
                    break block24;
                }
                System.out.printf("%-64s  %-6s  %-24s %-5s  %-14s  %-7s  %s%n", "#Group", "#Count", "#Version", "#Type", "#Model", "#TPS", "#Diff Total");
                TopicList topicList = defaultMQAdminExt.fetchAllTopicList();
                for (String topic : topicList.getTopicList()) {
                    if (!topic.startsWith("%RETRY%")) continue;
                    String consumerGroup = KeyBuilder.parseGroup((String)topic);
                    try {
                        ConsumeStats consumeStats = null;
                        try {
                            consumeStats = defaultMQAdminExt.examineConsumeStats(consumerGroup);
                        }
                        catch (Exception e) {
                            log.warn("examineConsumeStats exception, " + consumerGroup, (Throwable)e);
                        }
                        ConsumerConnection cc = null;
                        try {
                            cc = defaultMQAdminExt.examineConsumerConnectionInfo(consumerGroup);
                        }
                        catch (Exception e) {
                            log.warn("examineConsumerConnectionInfo exception, " + consumerGroup, (Throwable)e);
                        }
                        GroupConsumeInfo groupConsumeInfo = new GroupConsumeInfo();
                        groupConsumeInfo.setGroup(consumerGroup);
                        if (consumeStats != null) {
                            groupConsumeInfo.setConsumeTps((int)consumeStats.getConsumeTps());
                            groupConsumeInfo.setDiffTotal(consumeStats.computeTotalDiff());
                        }
                        if (cc != null) {
                            groupConsumeInfo.setCount(cc.getConnectionSet().size());
                            groupConsumeInfo.setMessageModel(cc.getMessageModel());
                            groupConsumeInfo.setConsumeType(cc.getConsumeType());
                            groupConsumeInfo.setVersion(cc.computeMinVersion());
                        }
                        System.out.printf("%-64s  %-6d  %-24s %-5s  %-14s  %-7d  %d%n", UtilAll.frontStringAtLeast((String)groupConsumeInfo.getGroup(), (int)64), groupConsumeInfo.getCount(), groupConsumeInfo.getCount() > 0 ? groupConsumeInfo.versionDesc() : "OFFLINE", groupConsumeInfo.consumeTypeDesc(), groupConsumeInfo.messageModelDesc(), groupConsumeInfo.getConsumeTps(), groupConsumeInfo.getDiffTotal());
                    }
                    catch (Exception e) {
                        log.warn("examineConsumeStats or examineConsumerConnectionInfo exception, " + consumerGroup, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
            }
            finally {
                defaultMQAdminExt.shutdown();
            }
        }
    }
}

