/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.consumer;

import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.utils.FilterUtils;
import org.apache.rocketmq.proxy.processor.PopMessageResultFilter;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class PopMessageResultFilterImpl
implements PopMessageResultFilter {
    private final int maxAttempts;

    public PopMessageResultFilterImpl(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @Override
    public PopMessageResultFilter.FilterResult filterMessage(ProxyContext ctx, String consumerGroup, SubscriptionData subscriptionData, MessageExt messageExt) {
        if (!FilterUtils.isTagMatched(subscriptionData.getTagsSet(), messageExt.getTags())) {
            return PopMessageResultFilter.FilterResult.NO_MATCH;
        }
        if (messageExt.getReconsumeTimes() >= this.maxAttempts) {
            return PopMessageResultFilter.FilterResult.TO_DLQ;
        }
        return PopMessageResultFilter.FilterResult.MATCH;
    }
}

