/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.entity.NodeId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.concurrent.ConcurrentHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class NodeManager {
    private static final NodeManager INSTANCE = new NodeManager();
    private final ConcurrentMap<NodeId, Node> nodeMap = new ConcurrentHashMap<NodeId, Node>();
    private final ConcurrentMap<String, List<Node>> groupMap = new ConcurrentHashMap<String, List<Node>>();
    private final ConcurrentHashSet<Endpoint> addrSet = new ConcurrentHashSet();

    public static NodeManager getInstance() {
        return INSTANCE;
    }

    public boolean serverExists(Endpoint addr) {
        if (addr.getIp().equals("0.0.0.0")) {
            return this.addrSet.contains(new Endpoint("0.0.0.0", addr.getPort()));
        }
        return this.addrSet.contains(addr);
    }

    public boolean removeAddress(Endpoint addr) {
        return this.addrSet.remove(addr);
    }

    public void addAddress(Endpoint addr) {
        this.addrSet.add(addr);
    }

    public boolean add(Node node) {
        if (!this.serverExists(node.getNodeId().getPeerId().getEndpoint())) {
            return false;
        }
        NodeId nodeId = node.getNodeId();
        if (this.nodeMap.putIfAbsent(nodeId, node) == null) {
            List existsNode;
            String groupId = node.getGroupId();
            List<Node> nodes = (List<Node>)this.groupMap.get(groupId);
            if (nodes == null && (existsNode = this.groupMap.putIfAbsent(groupId, nodes = Collections.synchronizedList(new ArrayList()))) != null) {
                nodes = existsNode;
            }
            nodes.add(node);
            return true;
        }
        return false;
    }

    @OnlyForTest
    public void clear() {
        this.groupMap.clear();
        this.nodeMap.clear();
        this.addrSet.clear();
    }

    public boolean remove(Node node) {
        List nodes;
        if (this.nodeMap.remove(node.getNodeId(), node) && (nodes = (List)this.groupMap.get(node.getGroupId())) != null) {
            return nodes.remove(node);
        }
        return false;
    }

    public Node get(String groupId, PeerId peerId) {
        return (Node)this.nodeMap.get(new NodeId(groupId, peerId));
    }

    public List<Node> getNodesByGroupId(String groupId) {
        return (List)this.groupMap.get(groupId);
    }

    public List<Node> getAllNodes() {
        return this.groupMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private NodeManager() {
    }
}

