/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.metrics;

import com.google.common.collect.Lists;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.util.List;
import java.util.function.Supplier;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.metrics.NopObservableDoubleGauge;
import org.apache.rocketmq.common.metrics.NopObservableLongGauge;
import org.apache.rocketmq.store.RocksDBMessageStore;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueStore;
import org.rocksdb.TickerType;

public class RocksDBStoreMetricsManager {
    public static Supplier<AttributesBuilder> attributesBuilderSupplier;
    public static MessageStoreConfig messageStoreConfig;
    public static ObservableLongGauge bytesRocksdbRead;
    public static ObservableLongGauge bytesRocksdbWritten;
    public static ObservableLongGauge timesRocksdbRead;
    public static ObservableLongGauge timesRocksdbWrittenSelf;
    public static ObservableLongGauge timesRocksdbWrittenOther;
    public static ObservableLongGauge timesRocksdbCompressed;
    public static ObservableDoubleGauge bytesRocksdbAmplificationRead;
    public static ObservableDoubleGauge rocksdbCacheHitRate;
    public static volatile long blockCacheHitTimes;
    public static volatile long blockCacheMissTimes;

    public static List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        return Lists.newArrayList();
    }

    public static void init(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier, RocksDBMessageStore messageStore) {
        RocksDBStoreMetricsManager.attributesBuilderSupplier = attributesBuilderSupplier;
        bytesRocksdbWritten = meter.gaugeBuilder("rocketmq_rocksdb_bytes_written").setDescription("The cumulative number of bytes written to the database.").ofLongs().buildWithCallback(measurement -> measurement.record(((RocksDBConsumeQueueStore)messageStore.getQueueStore()).getStatistics().getTickerCount(TickerType.BYTES_WRITTEN), RocksDBStoreMetricsManager.newAttributesBuilder().put("type", "consume_queue").build()));
        bytesRocksdbRead = meter.gaugeBuilder("rocketmq_rocksdb_bytes_read").setDescription("The cumulative number of bytes read from the database.").ofLongs().buildWithCallback(measurement -> measurement.record(((RocksDBConsumeQueueStore)messageStore.getQueueStore()).getStatistics().getTickerCount(TickerType.BYTES_READ), RocksDBStoreMetricsManager.newAttributesBuilder().put("type", "consume_queue").build()));
        timesRocksdbWrittenSelf = meter.gaugeBuilder("rocketmq_rocksdb_times_written_self").setDescription("The cumulative number of write operations performed by self.").ofLongs().buildWithCallback(measurement -> measurement.record(((RocksDBConsumeQueueStore)messageStore.getQueueStore()).getStatistics().getTickerCount(TickerType.WRITE_DONE_BY_SELF), RocksDBStoreMetricsManager.newAttributesBuilder().put("type", "consume_queue").build()));
        timesRocksdbWrittenOther = meter.gaugeBuilder("rocketmq_rocksdb_times_written_other").setDescription("The cumulative number of write operations performed by other.").ofLongs().buildWithCallback(measurement -> measurement.record(((RocksDBConsumeQueueStore)messageStore.getQueueStore()).getStatistics().getTickerCount(TickerType.WRITE_DONE_BY_OTHER), RocksDBStoreMetricsManager.newAttributesBuilder().put("type", "consume_queue").build()));
        timesRocksdbRead = meter.gaugeBuilder("rocketmq_rocksdb_times_read").setDescription("The cumulative number of write operations performed by other.").ofLongs().buildWithCallback(measurement -> measurement.record(((RocksDBConsumeQueueStore)messageStore.getQueueStore()).getStatistics().getTickerCount(TickerType.NUMBER_KEYS_READ), RocksDBStoreMetricsManager.newAttributesBuilder().put("type", "consume_queue").build()));
        rocksdbCacheHitRate = meter.gaugeBuilder("rocketmq_rocksdb_rate_cache_hit").setDescription("The rate at which cache lookups were served from the cache rather than needing to be fetched from disk.").buildWithCallback(measurement -> {
            long newMissTimes;
            long newHitTimes = ((RocksDBConsumeQueueStore)messageStore.getQueueStore()).getStatistics().getTickerCount(TickerType.BLOCK_CACHE_HIT);
            long totalPeriod = newHitTimes - blockCacheHitTimes + (newMissTimes = ((RocksDBConsumeQueueStore)messageStore.getQueueStore()).getStatistics().getTickerCount(TickerType.BLOCK_CACHE_MISS)) - blockCacheMissTimes;
            double hitRate = totalPeriod == 0L ? 0.0 : (double)(newHitTimes - blockCacheHitTimes) / (double)totalPeriod;
            blockCacheHitTimes = newHitTimes;
            blockCacheMissTimes = newMissTimes;
            measurement.record(hitRate, RocksDBStoreMetricsManager.newAttributesBuilder().put("type", "consume_queue").build());
        });
        timesRocksdbCompressed = meter.gaugeBuilder("rocketmq_rocksdb_times_compressed").setDescription("The cumulative number of compressions that have occurred.").ofLongs().buildWithCallback(measurement -> measurement.record(((RocksDBConsumeQueueStore)messageStore.getQueueStore()).getStatistics().getTickerCount(TickerType.NUMBER_BLOCK_COMPRESSED), RocksDBStoreMetricsManager.newAttributesBuilder().put("type", "consume_queue").build()));
        bytesRocksdbAmplificationRead = meter.gaugeBuilder("rocketmq_rocksdb_read_amplification_bytes").setDescription("The rate at which cache lookups were served from the cache rather than needing to be fetched from disk.").buildWithCallback(measurement -> measurement.record((double)((RocksDBConsumeQueueStore)messageStore.getQueueStore()).getStatistics().getTickerCount(TickerType.READ_AMP_TOTAL_READ_BYTES), RocksDBStoreMetricsManager.newAttributesBuilder().put("type", "consume_queue").build()));
    }

    public static AttributesBuilder newAttributesBuilder() {
        if (attributesBuilderSupplier == null) {
            return Attributes.builder();
        }
        return attributesBuilderSupplier.get().put("storage_type", "local").put("storage_medium", "disk");
    }

    static {
        bytesRocksdbRead = new NopObservableLongGauge();
        bytesRocksdbWritten = new NopObservableLongGauge();
        timesRocksdbRead = new NopObservableLongGauge();
        timesRocksdbWrittenSelf = new NopObservableLongGauge();
        timesRocksdbWrittenOther = new NopObservableLongGauge();
        timesRocksdbCompressed = new NopObservableLongGauge();
        bytesRocksdbAmplificationRead = new NopObservableDoubleGauge();
        rocksdbCacheHitRate = new NopObservableDoubleGauge();
        blockCacheHitTimes = 0L;
        blockCacheMissTimes = 0L;
    }
}

