/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.controller;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.header.controller.GetMetaDataResponseHeader;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class GetControllerMetaDataSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "getControllerMetaData";
    }

    @Override
    public String commandDesc() {
        return "Get controller cluster's metadata.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("a", "controllerAddress", true, "the address of controller");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        String controllerAddress = commandLine.getOptionValue('a').trim();
        try {
            defaultMQAdminExt.start();
            GetMetaDataResponseHeader metaData = defaultMQAdminExt.getControllerMetaData(controllerAddress);
            System.out.printf("\n#ControllerGroup\t%s", metaData.getGroup());
            System.out.printf("\n#ControllerLeaderId\t%s", metaData.getControllerLeaderId());
            System.out.printf("\n#ControllerLeaderAddress\t%s", metaData.getControllerLeaderAddress());
            String peers = metaData.getPeers();
            if (StringUtils.isNotEmpty((CharSequence)peers)) {
                String[] peerList;
                for (String peer : peerList = peers.split(";")) {
                    System.out.printf("\n#Peer:\t%s", peer);
                }
            }
            System.out.printf("\n", new Object[0]);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

