/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.monitor;

import java.util.Map;
import java.util.TreeMap;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.tools.monitor.DeleteMsgsEvent;
import org.apache.rocketmq.tools.monitor.FailedMsgs;
import org.apache.rocketmq.tools.monitor.MonitorListener;
import org.apache.rocketmq.tools.monitor.UndoneMsgs;

public class DefaultMonitorListener
implements MonitorListener {
    private static final String LOG_PREFIX = "[MONITOR] ";
    private static final String LOG_NOTIFY = "[MONITOR]  [NOTIFY] ";
    private final Logger logger = LoggerFactory.getLogger(DefaultMonitorListener.class);

    @Override
    public void beginRound() {
        this.logger.info("[MONITOR] =========================================beginRound");
    }

    @Override
    public void reportUndoneMsgs(UndoneMsgs undoneMsgs) {
        this.logger.info(String.format("[MONITOR] reportUndoneMsgs: %s", undoneMsgs));
    }

    @Override
    public void reportFailedMsgs(FailedMsgs failedMsgs) {
        this.logger.info(String.format("[MONITOR] reportFailedMsgs: %s", failedMsgs));
    }

    @Override
    public void reportDeleteMsgsEvent(DeleteMsgsEvent deleteMsgsEvent) {
        this.logger.info(String.format("[MONITOR] reportDeleteMsgsEvent: %s", deleteMsgsEvent));
    }

    @Override
    public void reportConsumerRunningInfo(TreeMap<String, ConsumerRunningInfo> criTable) {
        boolean result = ConsumerRunningInfo.analyzeSubscription(criTable);
        if (!result) {
            this.logger.info(String.format("[MONITOR]  [NOTIFY] reportConsumerRunningInfo: ConsumerGroup: %s, Subscription different", criTable.firstEntry().getValue().getProperties().getProperty("consumerGroup")));
        }
        for (Map.Entry<String, ConsumerRunningInfo> next : criTable.entrySet()) {
            String result2 = ConsumerRunningInfo.analyzeProcessQueue((String)next.getKey(), (ConsumerRunningInfo)next.getValue());
            if (result2.isEmpty()) continue;
            this.logger.info(String.format("[MONITOR]  [NOTIFY] reportConsumerRunningInfo: ConsumerGroup: %s, ClientId: %s, %s", criTable.firstEntry().getValue().getProperties().getProperty("consumerGroup"), next.getKey(), result2));
        }
    }

    @Override
    public void endRound() {
        this.logger.info("[MONITOR] =========================================endRound");
    }
}

